/*
 * Decompiled with CFR 0.152.
 */
package cc.ekblad.toml.serialization;

import cc.ekblad.toml.model.TomlException$ParseError;
import cc.ekblad.toml.model.TomlValue$Bool;
import cc.ekblad.toml.model.TomlValue$Double;
import cc.ekblad.toml.model.TomlValue$Integer;
import cc.ekblad.toml.model.TomlValue$List;
import cc.ekblad.toml.model.TomlValue$LocalDate;
import cc.ekblad.toml.model.TomlValue$LocalDateTime;
import cc.ekblad.toml.model.TomlValue$LocalTime;
import cc.ekblad.toml.model.TomlValue$Map;
import cc.ekblad.toml.model.TomlValue$OffsetDateTime;
import cc.ekblad.toml.model.TomlValue$Primitive;
import cc.ekblad.toml.model.TomlValue$String;
import cc.ekblad.toml.parser.TomlParser$Array_Context;
import cc.ekblad.toml.parser.TomlParser$Array_tableContext;
import cc.ekblad.toml.parser.TomlParser$Array_valuesContext;
import cc.ekblad.toml.parser.TomlParser$Bool_Context;
import cc.ekblad.toml.parser.TomlParser$Date_timeContext;
import cc.ekblad.toml.parser.TomlParser$DocumentContext;
import cc.ekblad.toml.parser.TomlParser$Dotted_keyContext;
import cc.ekblad.toml.parser.TomlParser$ExpressionContext;
import cc.ekblad.toml.parser.TomlParser$Floating_pointContext;
import cc.ekblad.toml.parser.TomlParser$Inline_tableContext;
import cc.ekblad.toml.parser.TomlParser$Inline_table_keyvals_non_emptyContext;
import cc.ekblad.toml.parser.TomlParser$IntegerContext;
import cc.ekblad.toml.parser.TomlParser$KeyContext;
import cc.ekblad.toml.parser.TomlParser$Key_valueContext;
import cc.ekblad.toml.parser.TomlParser$Quoted_keyContext;
import cc.ekblad.toml.parser.TomlParser$Simple_keyContext;
import cc.ekblad.toml.parser.TomlParser$Standard_tableContext;
import cc.ekblad.toml.parser.TomlParser$StringContext;
import cc.ekblad.toml.parser.TomlParser$TableContext;
import cc.ekblad.toml.parser.TomlParser$Unquoted_keyContext;
import cc.ekblad.toml.parser.TomlParser$ValueContext;
import cc.ekblad.toml.serialization.MutableTomlValue;
import cc.ekblad.toml.serialization.MutableTomlValue$InlineList;
import cc.ekblad.toml.serialization.MutableTomlValue$InlineMap;
import cc.ekblad.toml.serialization.MutableTomlValue$Primitive;
import cc.ekblad.toml.serialization.TomlBuilder;
import cc.ekblad.toml.serialization.TomlBuilder$Context;
import cc.ekblad.toml.serialization.TomlParserAdapterKt$convertEscapeCodes$1;
import cc.ekblad.toml.serialization.TomlParserAdapterKt$throwOnBadChar$badChars$1;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class TomlParserAdapterKt {
    private static final Regex escapeRegex;
    private static final List invalidTomlChars;

    public static final void extractDocument(TomlBuilder tomlBuilder, TomlParser$DocumentContext object) {
        TomlParser$DocumentContext tomlParser$DocumentContext = object;
        Intrinsics.checkNotNullParameter(tomlBuilder, "<this>");
        Intrinsics.checkNotNullParameter(tomlParser$DocumentContext, "ctx");
        List list = tomlParser$DocumentContext.expression();
        Intrinsics.checkNotNullExpressionValue(list, "ctx.expression()");
        for (TomlParser$ExpressionContext tomlParser$ExpressionContext : list) {
            Intrinsics.checkNotNullExpressionValue(tomlParser$ExpressionContext, "it");
            TomlParserAdapterKt.extractExpression(tomlBuilder, tomlParser$ExpressionContext);
        }
    }

    private static final void extractExpression(TomlBuilder object, TomlParser$ExpressionContext tomlParser$ExpressionContext) {
        ParserRuleContext parserRuleContext = tomlParser$ExpressionContext.key_value();
        if (parserRuleContext != null) {
            TomlParserAdapterKt.extractKeyValue((TomlBuilder)object, parserRuleContext);
        } else {
            parserRuleContext = tomlParser$ExpressionContext.table();
            if (parserRuleContext != null) {
                TomlParserAdapterKt.extractTable((TomlBuilder)object, (TomlParser$TableContext)parserRuleContext);
            } else {
                String string = tomlParser$ExpressionContext.comment().getText();
                Intrinsics.checkNotNullExpressionValue(string, "ctx.comment().text");
                char[] cArray = new char[2];
                object = cArray;
                cArray[0] = 13;
                cArray[1] = 10;
                TomlParserAdapterKt.throwOnBadChar(string, tomlParser$ExpressionContext, (char[])object);
            }
        }
    }

    private static final void extractTable(TomlBuilder object, TomlParser$TableContext tomlParser$TableContext) {
        Unit unit;
        TomlParser$Standard_tableContext tomlParser$Standard_tableContext = tomlParser$TableContext.standard_table();
        if (tomlParser$Standard_tableContext != null) {
            TomlParserAdapterKt.extractStandardTable((TomlBuilder)object, tomlParser$Standard_tableContext);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            TomlBuilder tomlBuilder = object;
            object = tomlParser$TableContext.array_table();
            Intrinsics.checkNotNullExpressionValue(object, "it");
            TomlParserAdapterKt.extractArrayTable(tomlBuilder, (TomlParser$Array_tableContext)object);
        }
    }

    private static final void extractKeyValue(TomlBuilder object, TomlParser$Key_valueContext object2) {
        TomlBuilder tomlBuilder = object;
        TomlParser$KeyContext tomlParser$KeyContext = ((TomlParser$Key_valueContext)object2).key();
        Intrinsics.checkNotNullExpressionValue(tomlParser$KeyContext, "ctx.key()");
        object = TomlParserAdapterKt.extractKey(tomlParser$KeyContext);
        int n = ((ParserRuleContext)object2).start.getLine();
        TomlBuilder$Context tomlBuilder$Context = tomlBuilder.defineTable(n, CollectionsKt.dropLast((List)object, 1), false);
        TomlParser$Key_valueContext tomlParser$Key_valueContext = object2;
        int n2 = ((ParserRuleContext)object2).start.getLine();
        object2 = (String)CollectionsKt.last((List)object);
        TomlParser$ValueContext tomlParser$ValueContext = tomlParser$Key_valueContext.value();
        Intrinsics.checkNotNullExpressionValue(tomlParser$ValueContext, "ctx.value()");
        tomlBuilder$Context.set(n2, (String)object2, TomlParserAdapterKt.extractValue(tomlParser$ValueContext));
    }

    private static final void extractStandardTable(TomlBuilder tomlBuilder, TomlParser$Standard_tableContext object) {
        TomlParser$KeyContext tomlParser$KeyContext = ((TomlParser$Standard_tableContext)object).key();
        Intrinsics.checkNotNullExpressionValue(tomlParser$KeyContext, "ctx.key()");
        List list = TomlParserAdapterKt.extractKey(tomlParser$KeyContext);
        Object object2 = list;
        object2 = (String)CollectionsKt.last((List)object2);
        tomlBuilder.resetContext();
        int n = ((ParserRuleContext)object).start.getLine();
        TomlBuilder$Context tomlBuilder$Context = tomlBuilder.defineTable(n, CollectionsKt.dropLast(list, 1), true);
        TomlBuilder$Context tomlBuilder$Context2 = tomlBuilder$Context.subcontext((String)object2);
        if (tomlBuilder$Context2 == null) {
            tomlBuilder$Context2 = TomlBuilder$Context.Companion.new();
        }
        int n2 = ((ParserRuleContext)object).start.getLine();
        object = tomlBuilder$Context2.asMap();
        tomlBuilder$Context.set(n2, (String)object2, (MutableTomlValue)object);
        tomlBuilder.setContext(tomlBuilder$Context2);
    }

    private static final void extractArrayTable(TomlBuilder tomlBuilder, TomlParser$Array_tableContext tomlParser$Array_tableContext) {
        TomlBuilder tomlBuilder2 = tomlBuilder;
        TomlParser$Array_tableContext tomlParser$Array_tableContext2 = tomlParser$Array_tableContext;
        TomlParserAdapterKt.throwOnWhitespaceBetweenBrackets(tomlParser$Array_tableContext2);
        TomlParser$KeyContext tomlParser$KeyContext = tomlParser$Array_tableContext2.key();
        Intrinsics.checkNotNullExpressionValue(tomlParser$KeyContext, "ctx.key()");
        List list = TomlParserAdapterKt.extractKey(tomlParser$KeyContext);
        tomlBuilder.resetContext();
        int n = tomlParser$Array_tableContext.start.getLine();
        TomlBuilder$Context tomlBuilder$Context = tomlBuilder2.defineTable(n, CollectionsKt.dropLast(list, 1), true);
        n = tomlParser$Array_tableContext.start.getLine();
        tomlBuilder2.setContext(tomlBuilder2.addTableArrayEntry(tomlBuilder$Context, n, (String)CollectionsKt.last(list)));
    }

    private static final void throwOnWhitespaceBetweenBrackets(TomlParser$Array_tableContext tomlParser$Array_tableContext) {
        TomlParser$Array_tableContext tomlParser$Array_tableContext2 = tomlParser$Array_tableContext;
        int n = tomlParser$Array_tableContext2.key().stop.getStopIndex() - tomlParser$Array_tableContext.key().start.getCharPositionInLine();
        if (tomlParser$Array_tableContext2.stop.getStopIndex() - tomlParser$Array_tableContext.start.getCharPositionInLine() - n <= 4) {
            return;
        }
        throw new TomlException$ParseError("whitespace between table array-defining double brackets is illegal", tomlParser$Array_tableContext.start.getLine());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final MutableTomlValue extractValue(TomlParser$ValueContext object) {
        Object object2 = ((TomlParser$ValueContext)object).string();
        if (object2 != null) {
            MutableTomlValue$Primitive mutableTomlValue$Primitive;
            object = mutableTomlValue$Primitive;
            mutableTomlValue$Primitive = new MutableTomlValue$Primitive(new TomlValue$String(TomlParserAdapterKt.extractString((TomlParser$StringContext)object2)));
            return object;
        }
        object2 = ((TomlParser$ValueContext)object).integer();
        if (object2 != null) {
            MutableTomlValue$Primitive mutableTomlValue$Primitive;
            object = mutableTomlValue$Primitive;
            mutableTomlValue$Primitive = new MutableTomlValue$Primitive(new TomlValue$Integer(TomlParserAdapterKt.extractInteger((TomlParser$IntegerContext)object2)));
            return object;
        }
        object2 = ((TomlParser$ValueContext)object).floating_point();
        if (object2 != null) {
            MutableTomlValue$Primitive mutableTomlValue$Primitive;
            MutableTomlValue$Primitive mutableTomlValue$Primitive2 = mutableTomlValue$Primitive;
            mutableTomlValue$Primitive = new MutableTomlValue$Primitive(new TomlValue$Double(TomlParserAdapterKt.extractDouble((TomlParser$Floating_pointContext)object2)));
            object2 = mutableTomlValue$Primitive2;
        } else {
            object2 = null;
        }
        if (object2 != null) return object2;
        object2 = ((TomlParser$ValueContext)object).bool_();
        if (object2 != null) {
            MutableTomlValue$Primitive mutableTomlValue$Primitive;
            MutableTomlValue$Primitive mutableTomlValue$Primitive3 = mutableTomlValue$Primitive;
            mutableTomlValue$Primitive = new MutableTomlValue$Primitive(new TomlValue$Bool(TomlParserAdapterKt.extractBool((TomlParser$Bool_Context)object2)));
            object2 = mutableTomlValue$Primitive3;
        } else {
            object2 = null;
        }
        if (object2 == null) {
            object2 = ((TomlParser$ValueContext)object).date_time();
            if (object2 != null) {
                MutableTomlValue$Primitive mutableTomlValue$Primitive;
                MutableTomlValue$Primitive mutableTomlValue$Primitive4 = mutableTomlValue$Primitive;
                mutableTomlValue$Primitive = new MutableTomlValue$Primitive(TomlParserAdapterKt.extractDateTime((TomlParser$Date_timeContext)object2));
                object2 = mutableTomlValue$Primitive4;
            } else {
                object2 = null;
            }
            if (object2 == null) {
                MutableTomlValue$InlineMap mutableTomlValue$InlineMap;
                object2 = ((TomlParser$ValueContext)object).array_();
                if (object2 != null) {
                    MutableTomlValue$InlineList mutableTomlValue$InlineList;
                    MutableTomlValue$InlineList mutableTomlValue$InlineList2 = mutableTomlValue$InlineList;
                    mutableTomlValue$InlineList = new MutableTomlValue$InlineList(TomlParserAdapterKt.extractList((TomlParser$Array_Context)object2));
                    object2 = mutableTomlValue$InlineList2;
                } else {
                    object2 = null;
                }
                if (object2 != null) return object2;
                object = ((TomlParser$ValueContext)object).inline_table();
                object2 = mutableTomlValue$InlineMap;
                Object object3 = object;
                Intrinsics.checkNotNullExpressionValue(object3, "it");
                mutableTomlValue$InlineMap = new MutableTomlValue$InlineMap(TomlParserAdapterKt.extractInlineTable((TomlParser$Inline_tableContext)object3));
                return object2;
            }
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final long extractInteger(TomlParser$IntegerContext tomlParser$IntegerContext) {
        TomlParser$IntegerContext tomlParser$IntegerContext2 = tomlParser$IntegerContext;
        String string = tomlParser$IntegerContext2.getText();
        Intrinsics.checkNotNullExpressionValue(string, "text");
        String string2 = StringsKt.replace$default(string, "_", "", false, 4, null);
        try {
            long l;
            if (tomlParser$IntegerContext2.DEC_INT() != null) {
                l = Long.parseLong(string2, CharsKt.checkRadix(10));
                return l;
            } else if (tomlParser$IntegerContext.HEX_INT() != null) {
                String string3 = string2.substring(2);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
                l = Long.parseLong(string3, CharsKt.checkRadix(16));
                return l;
            } else if (tomlParser$IntegerContext.BIN_INT() != null) {
                String string4 = string2.substring(2);
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).substring(startIndex)");
                l = Long.parseLong(string4, CharsKt.checkRadix(2));
                return l;
            } else {
                String string5 = string2.substring(2);
                Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
                l = Long.parseLong(string5, CharsKt.checkRadix(8));
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new TomlException$ParseError("integer '" + string2 + "' is out of range", tomlParser$IntegerContext.start.getLine(), numberFormatException);
        }
    }

    private static final double extractDouble(TomlParser$Floating_pointContext tomlParser$Floating_pointContext) {
        double d;
        TerminalNode terminalNode = tomlParser$Floating_pointContext.FLOAT();
        if (terminalNode != null) {
            String string = terminalNode.getText();
            Intrinsics.checkNotNullExpressionValue(string, "it.text");
            d = Double.parseDouble(StringsKt.replace$default(string, "_", "", false, 4, null));
        } else if (tomlParser$Floating_pointContext.INF() != null) {
            String string = tomlParser$Floating_pointContext.getText();
            Intrinsics.checkNotNullExpressionValue(string, "text");
            d = TomlParserAdapterKt.parseInfinity(string);
        } else {
            tomlParser$Floating_pointContext.NAN();
            d = Double.NaN;
        }
        return d;
    }

    private static final double parseInfinity(String string) {
        return StringsKt.first(string) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
    }

    private static final boolean extractBool(TomlParser$Bool_Context tomlParser$Bool_Context) {
        String string = tomlParser$Bool_Context.BOOLEAN().getText();
        Intrinsics.checkNotNullExpressionValue(string, "BOOLEAN().text");
        return StringsKt.toBooleanStrict(string);
    }

    /*
     * Unable to fully structure code
     */
    private static final TomlValue$Primitive extractDateTime(TomlParser$Date_timeContext var0) {
        block12: {
            block14: {
                block13: {
                    try {
                        var1_1 = var0.OFFSET_DATE_TIME();
                        if (var1_1 == null) ** GOTO lbl14
                    }
                    catch (DateTimeParseException var1_2) {
                        throw new TomlException$ParseError("date/time '" + var0.getText() + "' has invalid format", var0.start.getLine(), var1_2);
                    }
                    var2_3 = v0;
                    v1 = var1_1.getText();
                    Intrinsics.checkNotNullExpressionValue(v1, "it.text");
                    v2 = OffsetDateTime.parse(StringsKt.replace$default(v1, ' ', 'T', false, 4, null));
                    Intrinsics.checkNotNullExpressionValue(v2, "parse(it.text.replace(' ', 'T'))");
                    v0 = new TomlValue$OffsetDateTime(v2);
                    break block12;
lbl14:
                    // 1 sources

                    var1_1 = var0.LOCAL_DATE_TIME();
                    if (var1_1 == null) ** GOTO lbl24
                    var2_3 = v3;
                    v4 = var1_1.getText();
                    Intrinsics.checkNotNullExpressionValue(v4, "it.text");
                    v5 = LocalDateTime.parse(StringsKt.replace$default(v4, ' ', 'T', false, 4, null));
                    Intrinsics.checkNotNullExpressionValue(v5, "parse(it.text.replace(' ', 'T'))");
                    v3 = new TomlValue$LocalDateTime(v5);
                    break block12;
lbl24:
                    // 1 sources

                    var1_1 = var0.LOCAL_DATE();
                    if (var1_1 == null) break block13;
                    var2_3 = v6;
                    v7 = LocalDate.parse(var1_1.getText());
                    Intrinsics.checkNotNullExpressionValue(v7, "parse(it.text)");
                    v6 = new TomlValue$LocalDate(v7);
                    break block14;
                }
                var1_1 = null;
                var2_3 = var1_1;
            }
            if (var2_3 == null) {
                var1_1 = var0.LOCAL_TIME();
                var2_3 = v8;
                v9 = LocalTime.parse(var1_1.getText());
                Intrinsics.checkNotNullExpressionValue(v9, "parse(it.text)");
                v8 = new TomlValue$LocalTime(v9);
            }
        }
        return var2_3;
    }

    private static final TomlValue$List extractList(TomlParser$Array_Context object) {
        ArrayList arrayList;
        TomlParser$Array_Context tomlParser$Array_Context = object;
        object = arrayList;
        arrayList = new ArrayList();
        for (TomlParser$Array_valuesContext tomlParser$Array_valuesContext = (v23527).array_values(); tomlParser$Array_valuesContext != null; tomlParser$Array_valuesContext = tomlParser$Array_valuesContext.array_values()) {
            TomlParser$ValueContext tomlParser$ValueContext = tomlParser$Array_valuesContext.value();
            Intrinsics.checkNotNullExpressionValue(tomlParser$ValueContext, "ctx.value()");
            object.add(TomlParserAdapterKt.extractValue(tomlParser$ValueContext).freeze());
        }
        return new TomlValue$List((List)object);
    }

    private static final TomlValue$Map extractInlineTable(TomlParser$Inline_tableContext object) {
        TomlParser$Inline_tableContext tomlParser$Inline_tableContext = object;
        object = TomlBuilder.Companion.create();
        for (TomlParser$Inline_table_keyvals_non_emptyContext tomlParser$Inline_table_keyvals_non_emptyContext = (v23549).inline_table_keyvals().inline_table_keyvals_non_empty(); tomlParser$Inline_table_keyvals_non_emptyContext != null; tomlParser$Inline_table_keyvals_non_emptyContext = tomlParser$Inline_table_keyvals_non_emptyContext.inline_table_keyvals_non_empty()) {
            TomlParser$KeyContext tomlParser$KeyContext = tomlParser$Inline_table_keyvals_non_emptyContext.key();
            Intrinsics.checkNotNullExpressionValue(tomlParser$KeyContext, "ctx.key()");
            Object object2 = TomlParserAdapterKt.extractKey(tomlParser$KeyContext);
            int n = tomlParser$Inline_table_keyvals_non_emptyContext.start.getLine();
            TomlBuilder$Context tomlBuilder$Context = ((TomlBuilder)object).defineTable(n, CollectionsKt.dropLast((List)object2, 1), false);
            int n2 = tomlParser$Inline_table_keyvals_non_emptyContext.start.getLine();
            object2 = (String)CollectionsKt.last((List)object2);
            TomlParser$ValueContext tomlParser$ValueContext = tomlParser$Inline_table_keyvals_non_emptyContext.value();
            Intrinsics.checkNotNullExpressionValue(tomlParser$ValueContext, "ctx.value()");
            tomlBuilder$Context.set(n2, (String)object2, TomlParserAdapterKt.extractValue(tomlParser$ValueContext));
        }
        return ((TomlBuilder)object).build();
    }

    private static final String extractString(TomlParser$StringContext tomlParser$StringContext) {
        Object object;
        block9: {
            block8: {
                object = tomlParser$StringContext.BASIC_STRING();
                if (object == null) break block8;
                String string = object.getText();
                Intrinsics.checkNotNullExpressionValue(string, "it.text");
                object = TomlParserAdapterKt.convertEscapeCodes(TomlParserAdapterKt.throwOnBadChar(TomlParserAdapterKt.stripQuotes(string, 1), tomlParser$StringContext, new char[0]), tomlParser$StringContext.start.getLine());
                if (object != null) break block9;
            }
            if ((object = tomlParser$StringContext.ML_BASIC_STRING()) != null) {
                String string = object.getText();
                Intrinsics.checkNotNullExpressionValue(string, "it.text");
                object = TomlParserAdapterKt.convertEscapeCodes(TomlParserAdapterKt.throwOnBadChar(TomlParserAdapterKt.trimFirstNewline(TomlParserAdapterKt.stripQuotes(string, 3)), tomlParser$StringContext, new char[0]), tomlParser$StringContext.start.getLine());
            } else {
                object = tomlParser$StringContext.LITERAL_STRING();
                if (object != null) {
                    String string = object.getText();
                    Intrinsics.checkNotNullExpressionValue(string, "it.text");
                    char[] cArray = new char[2];
                    object = cArray;
                    cArray[0] = 13;
                    cArray[1] = 10;
                    object = TomlParserAdapterKt.throwOnBadChar(TomlParserAdapterKt.stripQuotes(string, 1), tomlParser$StringContext, (char[])object);
                } else {
                    object = null;
                }
                if (object == null) {
                    String string = tomlParser$StringContext.ML_LITERAL_STRING().getText();
                    Intrinsics.checkNotNullExpressionValue(string, "ML_LITERAL_STRING().text");
                    object = TomlParserAdapterKt.throwOnBadChar(TomlParserAdapterKt.trimFirstNewline(TomlParserAdapterKt.stripQuotes(string, 3)), tomlParser$StringContext, new char[0]);
                }
            }
        }
        return object;
    }

    private static final List extractKey(TomlParser$KeyContext tomlParser$KeyContext) {
        Object object = tomlParser$KeyContext.simple_key();
        if (object == null || (object = TomlParserAdapterKt.extractSimpleKey((TomlParser$Simple_keyContext)object)) == null) {
            TomlParser$Dotted_keyContext tomlParser$Dotted_keyContext = tomlParser$KeyContext.dotted_key();
            Intrinsics.checkNotNullExpressionValue(tomlParser$Dotted_keyContext, "dotted_key()");
            object = TomlParserAdapterKt.extractDottedKey(tomlParser$Dotted_keyContext);
        }
        return object;
    }

    private static final List extractDottedKey(TomlParser$Dotted_keyContext object) {
        ArrayList arrayList;
        List list = ((TomlParser$Dotted_keyContext)object).simple_key();
        Intrinsics.checkNotNullExpressionValue(list, "simple_key()");
        object = arrayList;
        arrayList = new ArrayList();
        for (TomlParser$Simple_keyContext tomlParser$Simple_keyContext : list) {
            Intrinsics.checkNotNullExpressionValue(tomlParser$Simple_keyContext, "it");
            CollectionsKt.addAll((Collection)object, TomlParserAdapterKt.extractSimpleKey(tomlParser$Simple_keyContext));
        }
        return object;
    }

    private static final List extractSimpleKey(TomlParser$Simple_keyContext tomlParser$Simple_keyContext) {
        Object object = tomlParser$Simple_keyContext.quoted_key();
        if (object == null || (object = TomlParserAdapterKt.extractQuotedKey((TomlParser$Quoted_keyContext)object)) == null) {
            TomlParser$Unquoted_keyContext tomlParser$Unquoted_keyContext = tomlParser$Simple_keyContext.unquoted_key();
            Intrinsics.checkNotNullExpressionValue(tomlParser$Unquoted_keyContext, "unquoted_key()");
            object = TomlParserAdapterKt.extractUnquotedKey(tomlParser$Unquoted_keyContext);
        }
        return object;
    }

    private static final List extractQuotedKey(TomlParser$Quoted_keyContext object) {
        Object object2;
        block3: {
            block2: {
                object2 = ((TomlParser$Quoted_keyContext)object).BASIC_STRING();
                if (object2 == null) break block2;
                String string = object2.getText();
                Intrinsics.checkNotNullExpressionValue(string, "it.text");
                char[] cArray = new char[2];
                object2 = cArray;
                cArray[0] = 13;
                cArray[1] = 10;
                object2 = CollectionsKt.listOf((Object)TomlParserAdapterKt.convertEscapeCodes(TomlParserAdapterKt.throwOnBadChar(TomlParserAdapterKt.stripQuotes(string, 1), (ParserRuleContext)object, (char[])object2), ((ParserRuleContext)object).start.getLine()));
                if (object2 != null) break block3;
            }
            String string = ((TomlParser$Quoted_keyContext)object).LITERAL_STRING().getText();
            Intrinsics.checkNotNullExpressionValue(string, "it.text");
            TomlParser$Quoted_keyContext tomlParser$Quoted_keyContext = object;
            char[] cArray = new char[2];
            object = cArray;
            cArray[0] = 13;
            cArray[1] = 10;
            object2 = CollectionsKt.listOf((Object)TomlParserAdapterKt.throwOnBadChar(TomlParserAdapterKt.stripQuotes(string, 1), tomlParser$Quoted_keyContext, (char[])object));
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final List extractUnquotedKey(TomlParser$Unquoted_keyContext tomlParser$Unquoted_keyContext) {
        boolean bl;
        String string = tomlParser$Unquoted_keyContext.getText();
        Intrinsics.checkNotNullExpressionValue(string, "text");
        List list = StringsKt.split$default((CharSequence)string, new char[]{'.'}, false, 0, 6, null);
        if (!(list instanceof Collection) || !list.isEmpty()) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                if (!StringsKt.contains$default((CharSequence)((String)iterator2.next()), '+', false, 2, null)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            return list;
        }
        throw new TomlException$ParseError("illegal character '+' encountered in key", tomlParser$Unquoted_keyContext.start.getLine());
    }

    private static final String throwOnBadChar(String object, ParserRuleContext parserRuleContext, char ... object2) {
        ArrayList arrayList;
        List list = CollectionsKt.plus((Collection)invalidTomlChars, (Iterable)ArraysKt.toList((char[])object2));
        object2 = arrayList;
        arrayList = new ArrayList();
        for (Object t : list) {
            if (!StringsKt.contains$default((CharSequence)object, ((Character)t).charValue(), false, 2, null)) continue;
            object2.add(t);
        }
        if (!(object2.isEmpty() ^ true)) {
            return object;
        }
        object = TomlParserAdapterKt$throwOnBadChar$badChars$1.INSTANCE;
        object = CollectionsKt.joinToString$default((Iterable)object2, ", ", null, null, 0, null, (Function1)object, 30, null);
        throw new TomlException$ParseError("disallowed character(s) encountered: " + (String)object, parserRuleContext.start.getLine());
    }

    private static final String stripQuotes(String string, int n) {
        String string2 = string.substring(n, string.length() - n);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    private static final String trimFirstNewline(String string) {
        if (StringsKt.startsWith$default((CharSequence)string, '\n', false, 2, null)) {
            string = StringsKt.drop(string, 1);
        } else if (StringsKt.startsWith$default(string, "\r\n", false, 2, null)) {
            string = StringsKt.drop(string, 2);
        }
        return string;
    }

    private static final String convertEscapeCodes(String object, int n) {
        TomlParserAdapterKt$convertEscapeCodes$1 tomlParserAdapterKt$convertEscapeCodes$1;
        String string = object;
        object = tomlParserAdapterKt$convertEscapeCodes$1;
        tomlParserAdapterKt$convertEscapeCodes$1 = new TomlParserAdapterKt$convertEscapeCodes$1(n);
        return escapeRegex.replace((CharSequence)string, (Function1)object);
    }

    private static final String replaceEscapeMatch(int n, MatchResult object) {
        Object object2;
        char c = object.getValue().charAt(1);
        if (c == '\"') {
            object2 = "\"";
        } else if (c == '\\') {
            object2 = "\\";
        } else if (c == 'b') {
            object2 = "\b";
        } else if (c == 'f') {
            object2 = "\f";
        } else if (c == 'n') {
            object2 = "\n";
        } else if (c == 'r') {
            object2 = "\r";
        } else if (c == 't') {
            object2 = "\t";
        } else if (c == 'u') {
            String string;
            char[] cArray = Character.toChars(TomlParserAdapterKt.throwOnNonScalar(Integer.parseInt((String)object.getGroupValues().get(2), CharsKt.checkRadix(16)), n));
            object2 = cArray;
            Intrinsics.checkNotNullExpressionValue(cArray, "toChars(match.groupValue\u2026).throwOnNonScalar(line))");
            object = string;
            string = new String((char[])object2);
            object2 = object;
        } else {
            String string;
            char[] cArray = Character.toChars(TomlParserAdapterKt.throwOnNonScalar(Integer.parseInt((String)object.getGroupValues().get(3), CharsKt.checkRadix(16)), n));
            object2 = cArray;
            Intrinsics.checkNotNullExpressionValue(cArray, "toChars(match.groupValue\u2026).throwOnNonScalar(line))");
            object = string;
            string = new String((char[])object2);
            object2 = object;
        }
        return object2;
    }

    private static final int throwOnNonScalar(int n, int n2) {
        if (!(55296 <= n && n < 57344)) {
            return n;
        }
        throw new TomlException$ParseError("surrogate character '" + n + "' is not a valid escape code", n2);
    }

    public static final /* synthetic */ String access$replaceEscapeMatch(int n, MatchResult matchResult) {
        return TomlParserAdapterKt.replaceEscapeMatch(n, matchResult);
    }

    static {
        CharRange charRange;
        CharRange charRange2;
        CharRange charRange3;
        escapeRegex = new Regex("\\\\([\\\\\"bnfrt]|u([0-9a-fA-F]{4})|U([0-9a-fA-F]{8}))");
        Object[] objectArray = new Iterable[4];
        CharRange charRange4 = charRange3;
        charRange3 = new CharRange('\u0000', '\b');
        objectArray[0] = charRange4;
        charRange4 = charRange2;
        charRange2 = new CharRange('\u000b', '\f');
        objectArray[1] = charRange4;
        charRange4 = charRange;
        charRange = new CharRange('\u000e', '\u001f');
        objectArray[2] = charRange4;
        objectArray[3] = CollectionsKt.listOf(Character.valueOf('\u007f'), Character.valueOf('\ufffd'));
        invalidTomlChars = CollectionsKt.flatten(CollectionsKt.listOf(objectArray));
    }
}

