/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.FunctionBase;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KFunction;

public abstract class FunctionReference
extends CallableReference
implements FunctionBase,
KFunction {
    private final int arity;
    private final int flags;

    public FunctionReference(int n) {
        this(n, CallableReference.NO_RECEIVER, null, null, null, 0);
    }

    public FunctionReference(int n, Object object) {
        this(n, object, null, null, null, 0);
    }

    public FunctionReference(int n, Object object, Class clazz, String string, String string2, int n2) {
        boolean bl = (n2 & 1) == 1;
        super(object, clazz, string, string2, bl);
        this.arity = n;
        this.flags = n2 >> 1;
    }

    public int getArity() {
        return this.arity;
    }

    @Override
    protected KFunction getReflected() {
        return (KFunction)super.getReflected();
    }

    @Override
    protected KCallable computeReflected() {
        return Reflection.function(this);
    }

    @Override
    public boolean isInline() {
        return this.getReflected().isInline();
    }

    @Override
    public boolean isExternal() {
        return this.getReflected().isExternal();
    }

    @Override
    public boolean isOperator() {
        return this.getReflected().isOperator();
    }

    @Override
    public boolean isInfix() {
        return this.getReflected().isInfix();
    }

    @Override
    public boolean isSuspend() {
        return this.getReflected().isSuspend();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FunctionReference) {
            object = (FunctionReference)object;
            return this.getName().equals(((CallableReference)object).getName()) && this.getSignature().equals(((CallableReference)object).getSignature()) && this.flags == ((FunctionReference)object).flags && this.arity == ((FunctionReference)object).arity && Intrinsics.areEqual(this.getBoundReceiver(), ((CallableReference)object).getBoundReceiver()) && Intrinsics.areEqual(this.getOwner(), ((CallableReference)object).getOwner());
        }
        if (object instanceof KFunction) {
            return object.equals(this.compute());
        }
        return false;
    }

    public int hashCode() {
        return ((this.getOwner() == null ? 0 : this.getOwner().hashCode() * 31) + this.getName().hashCode()) * 31 + this.getSignature().hashCode();
    }

    public String toString() {
        KCallable kCallable = this.compute();
        if (kCallable != this) {
            return kCallable.toString();
        }
        return "<init>".equals(this.getName()) ? "constructor (Kotlin reflection is not available)" : "function " + this.getName() + " (Kotlin reflection is not available)";
    }
}

