/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java8ParameterNamesLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner$DefaultImpls;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner$DefaultImpls;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaValueParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;

public abstract class ReflectJavaMember
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaMember {
    public abstract Member getMember();

    @Override
    public AnnotatedElement getElement() {
        Member member = this.getMember();
        Intrinsics.checkNotNull(member, "null cannot be cast to non-null type java.lang.reflect.AnnotatedElement");
        return (AnnotatedElement)((Object)member);
    }

    @Override
    public int getModifiers() {
        return this.getMember().getModifiers();
    }

    @Override
    public Name getName() {
        if ((object = (object = ((ReflectJavaMember)object).getMember().getName()) != null ? Name.identifier((String)object) : null) == null) {
            Object object = SpecialNames.NO_NAME_PROVIDED;
        }
        return object;
    }

    @Override
    public ReflectJavaClass getContainingClass() {
        Class<?> clazz = this.getMember().getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, "member.declaringClass");
        return new ReflectJavaClass(clazz);
    }

    protected final List getValueParameters(Type[] typeArray, Annotation[][] annotationArray, boolean bl) {
        ArrayList<ReflectJavaValueParameter> arrayList;
        Intrinsics.checkNotNullParameter(typeArray, "parameterTypes");
        Intrinsics.checkNotNullParameter(annotationArray, "parameterAnnotations");
        ArrayList<ReflectJavaValueParameter> arrayList2 = arrayList;
        arrayList = new ArrayList<ReflectJavaValueParameter>(typeArray.length);
        List list = Java8ParameterNamesLoader.INSTANCE.loadParameterNames(this.getMember());
        int n = list != null ? list.size() - typeArray.length : 0;
        int n2 = typeArray.length;
        for (int i = 0; i < n2; ++i) {
            ReflectJavaValueParameter reflectJavaValueParameter;
            String string;
            ReflectJavaType reflectJavaType = ReflectJavaType.Factory.create(typeArray[i]);
            if (list != null) {
                string = (String)CollectionsKt.getOrNull(list, i + n);
                if (string == null) {
                    throw new IllegalStateException(("No parameter with index " + i + '+' + n + " (name=" + this.getName() + " type=" + reflectJavaType + ") in " + this).toString());
                }
            } else {
                string = null;
            }
            boolean bl2 = bl && i == ArraysKt.getLastIndex(typeArray);
            ReflectJavaValueParameter reflectJavaValueParameter2 = reflectJavaValueParameter;
            reflectJavaValueParameter = new ReflectJavaValueParameter(reflectJavaType, annotationArray[i], string, bl2);
            arrayList2.add(reflectJavaValueParameter2);
        }
        return arrayList2;
    }

    public boolean equals(Object object) {
        return object instanceof ReflectJavaMember && Intrinsics.areEqual(this.getMember(), ((ReflectJavaMember)object).getMember());
    }

    public int hashCode() {
        return this.getMember().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getMember();
    }

    @Override
    public List getAnnotations() {
        return ReflectJavaAnnotationOwner$DefaultImpls.getAnnotations(this);
    }

    @Override
    public ReflectJavaAnnotation findAnnotation(FqName fqName2) {
        return ReflectJavaAnnotationOwner$DefaultImpls.findAnnotation(this, fqName2);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return ReflectJavaAnnotationOwner$DefaultImpls.isDeprecatedInJavaDoc(this);
    }

    @Override
    public boolean isAbstract() {
        return ReflectJavaModifierListOwner$DefaultImpls.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return ReflectJavaModifierListOwner$DefaultImpls.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return ReflectJavaModifierListOwner$DefaultImpls.isFinal(this);
    }

    @Override
    public Visibility getVisibility() {
        return ReflectJavaModifierListOwner$DefaultImpls.getVisibility(this);
    }
}

