/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;

public final class ReflectJavaWildcardType
extends ReflectJavaType
implements JavaWildcardType {
    private final WildcardType reflectType;
    private final Collection annotations;
    private final boolean isDeprecatedInJavaDoc;

    public ReflectJavaWildcardType(WildcardType wildcardType) {
        ReflectJavaWildcardType reflectJavaWildcardType = this;
        Intrinsics.checkNotNullParameter(wildcardType, "reflectType");
        reflectJavaWildcardType.reflectType = wildcardType;
        reflectJavaWildcardType.annotations = CollectionsKt.emptyList();
    }

    @Override
    protected WildcardType getReflectType() {
        return this.reflectType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ReflectJavaType getBound() {
        Object[] objectArray = ((ReflectJavaWildcardType)((Object)type2)).getReflectType().getUpperBounds();
        Object[] objectArray2 = ((ReflectJavaWildcardType)((Object)type2)).getReflectType().getLowerBounds();
        if (objectArray.length > 1) throw new UnsupportedOperationException("Wildcard types with many bounds are not yet supported: " + ((ReflectJavaWildcardType)((Object)type2)).getReflectType());
        if (objectArray2.length > 1) throw new UnsupportedOperationException("Wildcard types with many bounds are not yet supported: " + ((ReflectJavaWildcardType)((Object)type2)).getReflectType());
        if (objectArray2.length == 1) {
            Intrinsics.checkNotNullExpressionValue(objectArray2, "lowerBounds");
            Object object = ArraysKt.single(objectArray2);
            Intrinsics.checkNotNullExpressionValue(object, "lowerBounds.single()");
            return ReflectJavaType.Factory.create((Type)object);
        }
        if (objectArray.length != 1) return null;
        Intrinsics.checkNotNullExpressionValue(objectArray, "upperBounds");
        Type type2 = (Type)ArraysKt.single(objectArray);
        if (Intrinsics.areEqual(type2, Object.class)) return null;
        Type type3 = type2;
        Intrinsics.checkNotNullExpressionValue(type3, "ub");
        return ReflectJavaType.Factory.create(type3);
    }

    @Override
    public boolean isExtends() {
        Object[] objectArray = this.getReflectType().getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(objectArray, "reflectType.upperBounds");
        return Intrinsics.areEqual(ArraysKt.firstOrNull(objectArray), Object.class) ^ true;
    }

    @Override
    public Collection getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return this.isDeprecatedInJavaDoc;
    }
}

