/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;

public final class IndexedParametersSubstitution
extends TypeSubstitution {
    private final TypeParameterDescriptor[] parameters;
    private final TypeProjection[] arguments;
    private final boolean approximateContravariantCapturedTypes;

    public IndexedParametersSubstitution(TypeParameterDescriptor[] object, TypeProjection[] typeProjectionArray, boolean bl) {
        Intrinsics.checkNotNullParameter(object, "parameters");
        Intrinsics.checkNotNullParameter(typeProjectionArray, "arguments");
        this.parameters = object;
        this.arguments = typeProjectionArray;
        this.approximateContravariantCapturedTypes = bl;
        bl = ((TypeParameterDescriptor[])object).length <= typeProjectionArray.length;
        if (_Assertions.ENABLED && !bl) {
            object = "Number of arguments should not be less than number of parameters, but: parameters=" + ((TypeParameterDescriptor[])object).length + ", args=" + typeProjectionArray.length;
            throw new AssertionError(object);
        }
    }

    public /* synthetic */ IndexedParametersSubstitution(TypeParameterDescriptor[] typeParameterDescriptorArray, TypeProjection[] typeProjectionArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(typeParameterDescriptorArray, typeProjectionArray, bl);
    }

    public IndexedParametersSubstitution(List list, List list2) {
        TypeParameterDescriptor[] typeParameterDescriptorArray = typeParameterDescriptorArray3;
        Intrinsics.checkNotNullParameter(list, "parameters");
        Intrinsics.checkNotNullParameter(list2, "argumentsList");
        TypeParameterDescriptor[] typeParameterDescriptorArray2 = list.toArray(new TypeParameterDescriptor[0]);
        Intrinsics.checkNotNull(typeParameterDescriptorArray2, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        TypeParameterDescriptor[] typeParameterDescriptorArray3 = typeParameterDescriptorArray2;
        TypeProjection[] typeProjectionArray = list2.toArray(new TypeProjection[0]);
        Intrinsics.checkNotNull(typeProjectionArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        super(typeParameterDescriptorArray3, typeProjectionArray, false, 4, null);
    }

    public final TypeParameterDescriptor[] getParameters() {
        return this.parameters;
    }

    public final TypeProjection[] getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isEmpty() {
        return this.arguments.length == 0;
    }

    @Override
    public boolean approximateContravariantCapturedTypes() {
        return this.approximateContravariantCapturedTypes;
    }

    @Override
    public TypeProjection get(KotlinType annotated) {
        KotlinType kotlinType = annotated;
        Intrinsics.checkNotNullParameter(kotlinType, "key");
        annotated = kotlinType.getConstructor().getDeclarationDescriptor();
        annotated = annotated instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)annotated : null;
        if (annotated == null) {
            return null;
        }
        int n = annotated.getIndex();
        TypeParameterDescriptor[] typeParameterDescriptorArray = this.parameters;
        if (n < this.parameters.length && Intrinsics.areEqual(typeParameterDescriptorArray[n].getTypeConstructor(), annotated.getTypeConstructor())) {
            return this.arguments[n];
        }
        return null;
    }
}

