/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DelegatingSimpleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;

public final class SimpleTypeWithEnhancement
extends DelegatingSimpleType
implements TypeWithEnhancement {
    private final SimpleType delegate;
    private final KotlinType enhancement;

    public SimpleTypeWithEnhancement(SimpleType simpleType2, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter(simpleType2, "delegate");
        Intrinsics.checkNotNullParameter(kotlinType, "enhancement");
        this.delegate = simpleType2;
        this.enhancement = kotlinType;
    }

    @Override
    protected SimpleType getDelegate() {
        return this.delegate;
    }

    @Override
    public KotlinType getEnhancement() {
        return this.enhancement;
    }

    @Override
    public SimpleType getOrigin() {
        return this.getDelegate();
    }

    @Override
    public SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter(typeAttributes, "newAttributes");
        UnwrappedType unwrappedType = TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().replaceAttributes(typeAttributes), this.getEnhancement());
        Intrinsics.checkNotNull(unwrappedType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        return (SimpleType)unwrappedType;
    }

    @Override
    public SimpleType makeNullableAsSpecified(boolean bl) {
        UnwrappedType unwrappedType = TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().makeNullableAsSpecified(bl), this.getEnhancement().unwrap().makeNullableAsSpecified(bl));
        Intrinsics.checkNotNull(unwrappedType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        return (SimpleType)unwrappedType;
    }

    @Override
    public SimpleTypeWithEnhancement replaceDelegate(SimpleType simpleType2) {
        Intrinsics.checkNotNullParameter(simpleType2, "delegate");
        return new SimpleTypeWithEnhancement(simpleType2, this.getEnhancement());
    }

    @Override
    public SimpleTypeWithEnhancement refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        SimpleTypeWithEnhancement simpleTypeWithEnhancement = simpleType2;
        KotlinType kotlinType = kotlinTypeRefiner.refineType(simpleType2.getDelegate());
        Intrinsics.checkNotNull(kotlinType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        SimpleType simpleType2 = (SimpleType)kotlinType;
        return new SimpleTypeWithEnhancement(simpleType2, kotlinTypeRefiner.refineType(simpleTypeWithEnhancement.getEnhancement()));
    }

    @Override
    public String toString() {
        return "[@EnhancedForWarnings(" + this.getEnhancement() + ")] " + this.getOrigin();
    }
}

