/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorClassDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScope;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ThrowingScope;

public final class ErrorUtils {
    public static final ErrorUtils INSTANCE = new ErrorUtils();
    private static final ModuleDescriptor errorModule = ErrorModuleDescriptor.INSTANCE;
    private static final ErrorClassDescriptor errorClass;
    private static final KotlinType errorTypeForLoopInSupertypes;
    private static final KotlinType errorPropertyType;
    private static final PropertyDescriptor errorProperty;
    private static final Set errorPropertyGroup;

    private ErrorUtils() {
    }

    public static final ErrorScope createErrorScope(ErrorScopeKind errorScopeKind, String ... stringArray) {
        String[] stringArray2 = stringArray;
        Intrinsics.checkNotNullParameter((Object)errorScopeKind, "kind");
        Intrinsics.checkNotNullParameter(stringArray2, "formatParams");
        return ErrorUtils.createErrorScope(errorScopeKind, false, Arrays.copyOf(stringArray, stringArray2.length));
    }

    public static final ErrorScope createErrorScope(ErrorScopeKind errorScopeKind, boolean bl, String ... stringArray) {
        ErrorScope errorScope;
        Intrinsics.checkNotNullParameter((Object)errorScopeKind, "kind");
        Intrinsics.checkNotNullParameter(stringArray, "formatParams");
        if (bl) {
            ThrowingScope throwingScope;
            errorScope = throwingScope;
            throwingScope = new ThrowingScope(errorScopeKind, Arrays.copyOf(stringArray, stringArray.length));
        } else {
            ErrorScope errorScope2;
            errorScope = errorScope2;
            errorScope2 = new ErrorScope(errorScopeKind, Arrays.copyOf(stringArray, stringArray.length));
        }
        return errorScope;
    }

    public static final ErrorType createErrorType(ErrorTypeKind object, String ... stringArray) {
        Intrinsics.checkNotNullParameter(object, "kind");
        Intrinsics.checkNotNullParameter(stringArray, "formatParams");
        ErrorTypeKind errorTypeKind = object;
        object = CollectionsKt.emptyList();
        return INSTANCE.createErrorTypeWithArguments(errorTypeKind, (List)object, Arrays.copyOf(stringArray, stringArray.length));
    }

    public static final boolean isError(DeclarationDescriptor declarationDescriptor) {
        ErrorUtils errorUtils;
        return declarationDescriptor != null && ((errorUtils = INSTANCE).isErrorClass(declarationDescriptor) || errorUtils.isErrorClass(declarationDescriptor.getContainingDeclaration()) || declarationDescriptor == errorModule);
    }

    private final boolean isErrorClass(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor instanceof ErrorClassDescriptor;
    }

    public static final boolean isUninferredTypeVariable(KotlinType object) {
        if (object == null) {
            return false;
        }
        return (object = ((KotlinType)object).getConstructor()) instanceof ErrorTypeConstructor && ((ErrorTypeConstructor)object).getKind() == ErrorTypeKind.UNINFERRED_TYPE_VARIABLE;
    }

    static {
        String string = String.format(ErrorEntity.ERROR_CLASS.getDebugText(), Arrays.copyOf(new Object[]{"unknown class"}, 1));
        Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
        Name name = Name.special(string);
        Intrinsics.checkNotNullExpressionValue(name, "special(ErrorEntity.ERRO\u2026.format(\"unknown class\"))");
        errorClass = new ErrorClassDescriptor(name);
        errorTypeForLoopInSupertypes = ErrorUtils.createErrorType(ErrorTypeKind.CYCLIC_SUPERTYPES, new String[0]);
        errorPropertyType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_PROPERTY_TYPE, new String[0]);
        errorProperty = new ErrorPropertyDescriptor();
        errorPropertyGroup = SetsKt.setOf((Object)errorProperty);
    }

    public final ModuleDescriptor getErrorModule() {
        return errorModule;
    }

    public final ErrorClassDescriptor getErrorClass() {
        return errorClass;
    }

    public final KotlinType getErrorTypeForLoopInSupertypes() {
        return errorTypeForLoopInSupertypes;
    }

    public final KotlinType getErrorPropertyType() {
        return errorPropertyType;
    }

    public final Set getErrorPropertyGroup() {
        return errorPropertyGroup;
    }

    public final ErrorType createErrorType(ErrorTypeKind stringArray, TypeConstructor typeConstructor2, String ... stringArray2) {
        ErrorUtils errorUtils = list;
        String[] stringArray3 = stringArray;
        Intrinsics.checkNotNullParameter(stringArray, "kind");
        Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
        Intrinsics.checkNotNullParameter(stringArray2, "formatParams");
        List list = CollectionsKt.emptyList();
        stringArray = Arrays.copyOf(stringArray2, stringArray2.length);
        return errorUtils.createErrorTypeWithArguments((ErrorTypeKind)stringArray3, list, typeConstructor2, stringArray);
    }

    public final ErrorType createErrorTypeWithArguments(ErrorTypeKind errorTypeKind, List list, String ... stringArray) {
        ErrorUtils errorUtils = errorTypeConstructor;
        Intrinsics.checkNotNullParameter((Object)errorTypeKind, "kind");
        Intrinsics.checkNotNullParameter(list, "arguments");
        Intrinsics.checkNotNullParameter(stringArray, "formatParams");
        ErrorTypeConstructor errorTypeConstructor = ((ErrorUtils)((Object)errorTypeConstructor)).createErrorTypeConstructor(errorTypeKind, Arrays.copyOf(stringArray, stringArray.length));
        return errorUtils.createErrorTypeWithArguments(errorTypeKind, list, errorTypeConstructor, Arrays.copyOf(stringArray, stringArray.length));
    }

    public final ErrorType createErrorTypeWithArguments(ErrorTypeKind errorTypeKind, List list, TypeConstructor stringArray, String ... stringArray2) {
        Intrinsics.checkNotNullParameter((Object)errorTypeKind, "kind");
        Intrinsics.checkNotNullParameter(list, "arguments");
        Intrinsics.checkNotNullParameter(stringArray, "typeConstructor");
        Intrinsics.checkNotNullParameter(stringArray2, "formatParams");
        String[] stringArray3 = stringArray;
        ErrorScope errorScope = ErrorUtils.createErrorScope(ErrorScopeKind.ERROR_TYPE_SCOPE, stringArray.toString());
        stringArray = Arrays.copyOf(stringArray2, stringArray2.length);
        return new ErrorType((TypeConstructor)stringArray3, (MemberScope)errorScope, errorTypeKind, list, false, stringArray);
    }

    public final ErrorTypeConstructor createErrorTypeConstructor(ErrorTypeKind errorTypeKind, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)errorTypeKind, "kind");
        Intrinsics.checkNotNullParameter(stringArray, "formatParams");
        return new ErrorTypeConstructor(errorTypeKind, Arrays.copyOf(stringArray, stringArray.length));
    }
}

