/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.lang.ref.Reference;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealCall$CallReference;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool$Companion;
import okhttp3.internal.connection.RealConnectionPool$cleanupTask$1;
import okhttp3.internal.platform.Platform;

public final class RealConnectionPool {
    public static final RealConnectionPool$Companion Companion = new RealConnectionPool$Companion(null);
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final TaskQueue cleanupQueue;
    private final RealConnectionPool$cleanupTask$1 cleanupTask;
    private final ConcurrentLinkedQueue connections;

    public RealConnectionPool(TaskRunner object, int n, long l, TimeUnit timeUnit) {
        RealConnectionPool realConnectionPool = this;
        Intrinsics.checkNotNullParameter(object, "taskRunner");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        this.maxIdleConnections = n;
        this.keepAliveDurationNs = timeUnit.toNanos(l);
        realConnectionPool.cleanupQueue = ((TaskRunner)object).newQueue();
        object = Intrinsics.stringPlus(Util.okHttpName, " ConnectionPool");
        realConnectionPool.cleanupTask = new RealConnectionPool$cleanupTask$1(this, (String)object);
        realConnectionPool.connections = new ConcurrentLinkedQueue();
        if (l > 0L) {
            return;
        }
        object = Intrinsics.stringPlus("keepAliveDuration <= 0: ", l);
        throw new IllegalArgumentException(object.toString());
    }

    private final int pruneAndGetAllocationCount(RealConnection realConnection, long l) {
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        List list = realConnection.getCalls();
        int n = 0;
        while (n < list.size()) {
            Reference reference = (Reference)list.get(n);
            if (reference.get() != null) {
                ++n;
                continue;
            }
            reference = (RealCall$CallReference)reference;
            Platform.Companion.get().logCloseableLeak("A connection to " + realConnection.route().address().url() + " was leaked. Did you forget to close a response body?", ((RealCall$CallReference)reference).getCallStackTrace());
            list.remove(n);
            realConnection.setNoNewExchanges(true);
            if (!list.isEmpty()) continue;
            realConnection.setIdleAtNs$okhttp(l - this.keepAliveDurationNs);
            return 0;
        }
        return list.size();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final boolean callAcquirePooledConnection(Address var1_1, RealCall var2_2, List var3_3, boolean var4_4) {
        block6: {
            Intrinsics.checkNotNullParameter(var1_1, "address");
            Intrinsics.checkNotNullParameter(var2_2, "call");
            this = this.connections.iterator();
            while (this.hasNext() != false) {
                block7: {
                    var5_5 = (RealConnection)this.next();
                    Intrinsics.checkNotNullExpressionValue(var5_5, "connection");
                    // MONITORENTER : var5_5
                    if (!var4_4) ** GOTO lbl11
                    if (!var5_5.isMultiplexed$okhttp()) break block7;
lbl11:
                    // 2 sources

                    if (var5_5.isEligible$okhttp(var1_1, var3_3)) break block6;
                }
                v0 = var5_5;
            }
            return false;
        }
        var2_2.acquireConnectionNoEvents(var5_5);
        // MONITOREXIT : var5_5
        return true;
    }

    public final void put(RealConnection realConnection) {
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        RealConnectionPool realConnectionPool = this;
        realConnectionPool.connections.add(realConnection);
        TaskQueue.schedule$default(realConnectionPool.cleanupQueue, this.cleanupTask, 0L, 2, null);
    }

    public final boolean connectionBecameIdle(RealConnection realConnection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        if (!realConnection.getNoNewExchanges() && this.maxIdleConnections != 0) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
            bl = false;
        } else {
            RealConnectionPool realConnectionPool = this;
            realConnection.setNoNewExchanges(true);
            realConnectionPool.connections.remove(realConnection);
            if (realConnectionPool.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void evictAll() {
        Iterator iterator2 = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "connections.iterator()");
        while (iterator2.hasNext()) {
            Socket socket;
            RealConnection realConnection = (RealConnection)iterator2.next();
            Intrinsics.checkNotNullExpressionValue(realConnection, "connection");
            synchronized (realConnection) {
                if (realConnection.getCalls().isEmpty()) {
                    RealConnection realConnection2 = realConnection;
                    iterator2.remove();
                    realConnection2.setNoNewExchanges(true);
                    socket = realConnection2.socket();
                } else {
                    socket = null;
                }
                if (socket == null) continue;
            }
            Util.closeQuietly(socket);
        }
        if (this.connections.isEmpty()) {
            this.cleanupQueue.cancelAll();
        }
    }

    /*
     * Unable to fully structure code
     */
    public final long cleanup(long var1_1) {
        var3_2 = 0;
        var4_3 = 0;
        var5_4 = null;
        var6_5 = -9223372036854775808L;
        for (RealConnection var9_8 : this.connections) {
            Intrinsics.checkNotNullExpressionValue(var9_8, "connection");
            synchronized (var9_8) {
                block16: {
                    block17: {
                        if (this.pruneAndGetAllocationCount(var9_8, var1_1) > 0) {
                            ++var3_2;
                            break block16;
                        }
                        ++var4_3;
                        var10_9 = var1_1 - var9_8.getIdleAtNs$okhttp();
                        if (var10_9 <= var6_5) break block17;
                        var6_5 = var10_9;
                        var5_4 = var9_8;
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 93->96)] { 
lbl22:
                    // 1 sources

                }
            }
        }
        var8_7 = this.keepAliveDurationNs;
        if (var6_5 < var8_7 && var4_3 <= this.maxIdleConnections) {
            if (var4_3 > 0) {
                return var8_7 - var6_5;
            }
            if (var3_2 > 0) {
                return var8_7;
            }
            return -1L;
        }
        v1 = var5_4;
        Intrinsics.checkNotNull(v1);
        synchronized (v1) {
            block19: {
                block18: {
                    if (!(v1.getCalls().isEmpty() ^ true)) break block18;
                    return 0L;
                }
                if (var5_4.getIdleAtNs$okhttp() + var6_5 == var1_1) break block19;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return 0L;
            }
            v3 = this;
            v4 = var5_4;
            v5 = v4;
            v6 = v4;
            var5_4.setNoNewExchanges(true);
            this.connections.remove(var5_4);
            Util.closeQuietly(v6.socket());
            if (v3.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return 0L;
        }
    }
}

