/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.net.http.X509TrustManagerExtensions;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.android.AndroidCertificateChainCleaner$Companion;
import okhttp3.internal.tls.CertificateChainCleaner;

public final class AndroidCertificateChainCleaner
extends CertificateChainCleaner {
    public static final AndroidCertificateChainCleaner$Companion Companion = new AndroidCertificateChainCleaner$Companion(null);
    private final X509TrustManager trustManager;
    private final X509TrustManagerExtensions x509TrustManagerExtensions;

    public AndroidCertificateChainCleaner(X509TrustManager x509TrustManager, X509TrustManagerExtensions x509TrustManagerExtensions) {
        Intrinsics.checkNotNullParameter(x509TrustManager, "trustManager");
        Intrinsics.checkNotNullParameter(x509TrustManagerExtensions, "x509TrustManagerExtensions");
        this.trustManager = x509TrustManager;
        this.x509TrustManagerExtensions = x509TrustManagerExtensions;
    }

    @Override
    public List clean(List x509CertificateArray, String string) {
        Intrinsics.checkNotNullParameter(x509CertificateArray, "chain");
        Intrinsics.checkNotNullParameter(string, "hostname");
        x509CertificateArray = x509CertificateArray.toArray(new X509Certificate[0]);
        if (x509CertificateArray != null) {
            X509Certificate[] x509CertificateArray2 = x509CertificateArray3;
            X509Certificate[] x509CertificateArray3 = x509CertificateArray;
            try {
                List list = x509CertificateArray2.x509TrustManagerExtensions.checkServerTrusted(x509CertificateArray3, "RSA", string);
                Intrinsics.checkNotNullExpressionValue(list, "x509TrustManagerExtensio\u2026ficates, \"RSA\", hostname)");
                return list;
            }
            catch (CertificateException certificateException) {
                SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(certificateException.getMessage());
                sSLPeerUnverifiedException.initCause(certificateException);
                throw sSLPeerUnverifiedException;
            }
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
    }

    public boolean equals(Object object) {
        return object instanceof AndroidCertificateChainCleaner && ((AndroidCertificateChainCleaner)object).trustManager == this.trustManager;
    }

    public int hashCode() {
        return System.identityHashCode(this.trustManager);
    }
}

