/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.Buffer$inputStream$1;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Segment;
import okio.SegmentPool;
import okio.SegmentedByteString;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio._UtilKt;
import okio.internal._BufferKt;

public final class Buffer
implements BufferedSource,
BufferedSink,
Cloneable,
ByteChannel {
    public Segment head;
    private long size;

    public final long size() {
        return this.size;
    }

    public final void setSize$okio(long l) {
        this.size = l;
    }

    @Override
    public Buffer getBuffer() {
        return this;
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long l) {
        if (this.size >= l) {
            return;
        }
        throw new EOFException();
    }

    @Override
    public InputStream inputStream() {
        return new Buffer$inputStream$1(this);
    }

    public final Buffer copyTo(Buffer buffer, long l, long l2) {
        Intrinsics.checkNotNullParameter(buffer, "out");
        _UtilKt.checkOffsetAndCount(this.size(), l, l2);
        if (l2 != 0L) {
            Buffer buffer2 = buffer;
            buffer2.setSize$okio(buffer2.size() + l2);
            Segment segment = this.head;
            while (true) {
                Segment segment2 = segment;
                Intrinsics.checkNotNull(segment2);
                int n = segment2.limit;
                int n2 = segment.pos;
                if (l < (long)(n - n2)) break;
                l -= (long)(n - n2);
                segment = segment.next;
            }
            while (l2 > 0L) {
                int n;
                Segment segment3 = segment;
                Intrinsics.checkNotNull(segment3);
                Segment segment4 = segment3.sharedCopy();
                segment4.pos = n = segment4.pos + (int)l;
                segment4.limit = Math.min(n + (int)l2, segment4.limit);
                Segment segment5 = buffer.head;
                if (segment5 == null) {
                    segment4.prev = segment4;
                    segment4.next = segment4;
                    buffer.head = segment4;
                } else {
                    Segment segment6 = segment5;
                    Intrinsics.checkNotNull(segment6);
                    Segment segment7 = segment6.prev;
                    Intrinsics.checkNotNull(segment7);
                    segment7.push(segment4);
                }
                l2 -= (long)(segment4.limit - segment4.pos);
                l = 0L;
                segment = segment.next;
            }
        }
        return this;
    }

    public final long completeSegmentByteCount() {
        long l = ((Buffer)((Object)segment2)).size();
        if (l == 0L) {
            l = 0L;
        } else {
            Segment segment = ((Buffer)((Object)segment2)).head;
            Intrinsics.checkNotNull(segment);
            Segment segment2 = segment.prev;
            Intrinsics.checkNotNull(segment2);
            int n = segment2.limit;
            if (n < 8192 && segment2.owner) {
                l -= (long)(n - segment2.pos);
            }
        }
        return l;
    }

    @Override
    public byte readByte() {
        if (this.size() != 0L) {
            Segment segment = this.head;
            Intrinsics.checkNotNull(segment);
            int by = segment.pos;
            int n = segment.limit;
            byte[] byArray = segment.data;
            int n2 = by + 1;
            Buffer buffer = this;
            byte by2 = byArray[by];
            buffer.setSize$okio(buffer.size() - 1L);
            if (n2 == n) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n2;
            }
            return by2;
        }
        throw new EOFException();
    }

    public final byte getByte(long l) {
        Buffer buffer = this;
        _UtilKt.checkOffsetAndCount(buffer.size(), l, 1L);
        Segment segment = buffer.head;
        if (segment != null) {
            byte by;
            if (this.size() - l < l) {
                long l2;
                for (l2 = this.size(); l2 > l; l2 -= (long)(segment.limit - segment.pos)) {
                    segment = segment.prev;
                    Intrinsics.checkNotNull(segment);
                }
                Segment segment2 = segment;
                Intrinsics.checkNotNull(segment2);
                by = segment2.data[(int)((long)segment.pos + l - l2)];
            } else {
                long l3;
                long l4 = 0L;
                while ((l3 = l4 + (long)(segment.limit - segment.pos)) <= l) {
                    segment = segment.next;
                    Intrinsics.checkNotNull(segment);
                    l4 = l3;
                }
                Segment segment3 = segment;
                Intrinsics.checkNotNull(segment3);
                by = segment3.data[(int)((long)segment.pos + l - l4)];
            }
            return by;
        }
        Intrinsics.checkNotNull(null);
        throw null;
    }

    @Override
    public short readShort() {
        if (this.size() >= 2L) {
            short s;
            Segment segment = this.head;
            Intrinsics.checkNotNull(segment);
            int n = segment.pos;
            int n2 = segment.limit;
            if (n2 - n < 2) {
                s = (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
            } else {
                byte[] byArray = segment.data;
                int n3 = (segment.data[n++] & 0xFF) << 8;
                int n4 = n + 1;
                Buffer buffer = this;
                n = n3 | byArray[n] & 0xFF;
                buffer.setSize$okio(buffer.size() - 2L);
                if (n4 == n2) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                } else {
                    segment.pos = n4;
                }
                s = (short)n;
            }
            return s;
        }
        throw new EOFException();
    }

    @Override
    public int readInt() {
        if (this.size() >= 4L) {
            int n;
            Segment segment = this.head;
            Intrinsics.checkNotNull(segment);
            int n2 = segment.pos;
            int n3 = segment.limit;
            if ((long)(n3 - n2) < 4L) {
                n = (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            } else {
                byte[] byArray = segment.data;
                int n4 = (segment.data[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8;
                int n5 = n2 + 1;
                Buffer buffer = this;
                n2 = n4 | byArray[n2] & 0xFF;
                buffer.setSize$okio(buffer.size() - 4L);
                if (n5 == n3) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                } else {
                    segment.pos = n5;
                }
                n = n2;
            }
            return n;
        }
        throw new EOFException();
    }

    public long readLong() {
        if (this.size() >= 8L) {
            long l;
            Segment segment = this.head;
            Intrinsics.checkNotNull(segment);
            int n = segment.pos;
            int n2 = segment.limit;
            if ((long)(n2 - n) < 8L) {
                l = ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
            } else {
                byte[] byArray = segment.data;
                long l2 = ((long)segment.data[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8;
                int n3 = n + 1;
                Buffer buffer = this;
                long l3 = l2 | (long)byArray[n] & 0xFFL;
                buffer.setSize$okio(buffer.size() - 8L);
                if (n3 == n2) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                } else {
                    segment.pos = n3;
                }
                l = l3;
            }
            return l;
        }
        throw new EOFException();
    }

    @Override
    public short readShortLe() {
        return _UtilKt.reverseBytes(this.readShort());
    }

    @Override
    public int readIntLe() {
        return _UtilKt.reverseBytes(this.readInt());
    }

    @Override
    public long readLongLe() {
        return _UtilKt.reverseBytes(this.readLong());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long readHexadecimalUnsignedLong() {
        if (buffer2.size() == 0L) {
            throw new EOFException();
        }
        long l = 0L;
        int n = 0;
        boolean bl = false;
        do {
            int n2;
            Segment segment = buffer2.head;
            Intrinsics.checkNotNull(segment);
            byte[] byArray = segment.data;
            int n3 = segment.limit;
            for (n2 = segment.pos; n2 < n3; ++n2, ++n) {
                byte by;
                block12: {
                    int n4;
                    block10: {
                        block11: {
                            block9: {
                                by = byArray[n2];
                                n4 = 48;
                                if (by < n4 || by > (byte)57) break block9;
                                n4 = by - n4;
                                break block10;
                            }
                            n4 = 97;
                            if (by >= n4 && by <= (byte)102) break block11;
                            byte by2 = (byte)65;
                            n4 = by2;
                            if (by < by2 || by > (byte)70) break block12;
                        }
                        n4 = by - n4 + 10;
                    }
                    if ((l & 0xF000000000000000L) != 0L) {
                        Buffer buffer;
                        Buffer buffer2 = buffer;
                        buffer2();
                        buffer2 = buffer.writeHexadecimalUnsignedLong(l).writeByte(by);
                        throw new NumberFormatException("Number too large: " + buffer2.readUtf8());
                    }
                    l = l << 4 | (long)n4;
                    continue;
                }
                if (n == 0) {
                    throw new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x" + _UtilKt.toHexString(by));
                }
                bl = true;
                break;
            }
            if (n2 == n3) {
                buffer2.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n2;
        } while (!bl && buffer2.head != null);
        Buffer buffer = buffer2;
        buffer.setSize$okio(buffer.size() - (long)n);
        return l;
    }

    public ByteString readByteString() {
        Buffer buffer = this;
        return buffer.readByteString(buffer.size());
    }

    @Override
    public ByteString readByteString(long l) {
        Object object;
        if (l >= 0L && l <= Integer.MAX_VALUE) {
            if (((Buffer)object).size() >= l) {
                if (l >= 4096L) {
                    Object object2 = object;
                    object = ((Buffer)object).snapshot((int)l);
                    ((Buffer)object2).skip(l);
                } else {
                    ByteString byteString;
                    ByteString byteString2 = byteString;
                    byteString = new ByteString(((Buffer)object).readByteArray(l));
                    object = byteString2;
                }
                return object;
            }
            throw new EOFException();
        }
        object = "byteCount: " + l;
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public int select(Options options) {
        Intrinsics.checkNotNullParameter(options, "options");
        int n = _BufferKt.selectPrefix$default(this, options, false, 2, null);
        if (n == -1) {
            n = -1;
        } else {
            this.skip(options.getByteStrings$okio()[n].size());
        }
        return n;
    }

    @Override
    public long readAll(Sink sink2) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        long l = this.size();
        if (l > 0L) {
            sink2.write(this, l);
        }
        return l;
    }

    public String readUtf8() {
        Buffer buffer = this;
        return buffer.readString(buffer.size, Charsets.UTF_8);
    }

    @Override
    public String readUtf8(long l) {
        return this.readString(l, Charsets.UTF_8);
    }

    public String readString(long l, Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        long l2 = l - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        if (l3 >= 0 && l <= Integer.MAX_VALUE) {
            if (((Buffer)((Object)string)).size >= l) {
                int n;
                String string;
                if (l3 == false) {
                    return "";
                }
                Segment segment = ((Buffer)((Object)string)).head;
                Intrinsics.checkNotNull(segment);
                int n2 = segment.pos;
                if ((long)n2 + l > (long)segment.limit) {
                    return new String(((Buffer)((Object)string)).readByteArray(l), charset);
                }
                String string2 = string;
                byte[] byArray = segment.data;
                int n3 = (int)l;
                string = new String(byArray, n2, n3, charset);
                segment.pos = n = segment.pos + n3;
                ((Buffer)((Object)string)).size -= l;
                if (n == segment.limit) {
                    ((Buffer)((Object)string)).head = segment.pop();
                    SegmentPool.recycle(segment);
                }
                return string2;
            }
            throw new EOFException();
        }
        String string = "byteCount: " + l;
        throw new IllegalArgumentException(string.toString());
    }

    @Override
    public String readUtf8LineStrict() {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long l) {
        block2: {
            Buffer buffer;
            block5: {
                String string;
                block4: {
                    long l2;
                    byte by;
                    block3: {
                        if (!(l >= 0L)) break block2;
                        by = (byte)10;
                        l2 = l == Long.MAX_VALUE ? Long.MAX_VALUE : l + 1L;
                        long l3 = ((Buffer)((Object)string)).indexOf(by, 0L, l2);
                        if (l3 == -1L) break block3;
                        string = _BufferKt.readUtf8Line((Buffer)((Object)string), l3);
                        break block4;
                    }
                    if (l2 >= ((Buffer)((Object)string)).size() || ((Buffer)((Object)string)).getByte(l2 - 1L) != (byte)13 || ((Buffer)((Object)string)).getByte(l2) != by) break block5;
                    string = _BufferKt.readUtf8Line((Buffer)((Object)string), l2);
                }
                return string;
            }
            String string = string;
            Buffer buffer2 = buffer;
            buffer = new Buffer();
            long l4 = ((Buffer)((Object)string)).size();
            l4 = Math.min((long)32, l4);
            ((Buffer)((Object)string)).copyTo(buffer2, 0L, l4);
            throw new EOFException("\\n not found: limit=" + Math.min(((Buffer)((Object)string)).size(), l) + " content=" + buffer2.readByteString().hex() + '\u2026');
        }
        String string = "limit < 0: " + l;
        throw new IllegalArgumentException(string.toString());
    }

    public byte[] readByteArray() {
        Buffer buffer = this;
        return buffer.readByteArray(buffer.size());
    }

    @Override
    public byte[] readByteArray(long l) {
        if (l >= 0L && l <= Integer.MAX_VALUE) {
            if (((Buffer)((Object)string)).size() >= l) {
                byte[] byArray = new byte[(int)l];
                ((Buffer)((Object)string)).readFully(byArray);
                return byArray;
            }
            throw new EOFException();
        }
        String string = "byteCount: " + l;
        throw new IllegalArgumentException(string.toString());
    }

    public void readFully(byte[] byArray) {
        int n;
        Intrinsics.checkNotNullParameter(byArray, "sink");
        for (int i = 0; i < byArray.length; i += n) {
            n = this.read(byArray, i, byArray.length - i);
            if (n != -1) {
                continue;
            }
            throw new EOFException();
        }
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3;
        Intrinsics.checkNotNullParameter(byArray, "sink");
        long l = n;
        long l2 = n2;
        _UtilKt.checkOffsetAndCount(byArray.length, l, l2);
        Segment segment = this.head;
        if (segment == null) {
            n3 = -1;
        } else {
            Buffer buffer = this;
            Segment segment2 = segment;
            n2 = Math.min(n2, segment.limit - segment.pos);
            int n4 = segment.pos;
            int n5 = n4 + n2;
            ArraysKt.copyInto(segment2.data, byArray, n, n4, n5);
            segment2.pos += n2;
            buffer.setSize$okio(buffer.size() - (long)n2);
            if (segment.pos == segment.limit) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            }
            n3 = n2;
        }
        return n3;
    }

    @Override
    public int read(ByteBuffer byteBuffer) {
        int n;
        Intrinsics.checkNotNullParameter(byteBuffer, "sink");
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment segment2 = segment;
        int n2 = Math.min(byteBuffer.remaining(), segment.limit - segment.pos);
        byte[] byArray = segment2.data;
        byteBuffer.put(byArray, segment2.pos, n2);
        segment.pos = n = segment.pos + n2;
        this.size -= (long)n2;
        if (n == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n2;
    }

    public final void clear() {
        Buffer buffer = this;
        buffer.skip(buffer.size());
    }

    @Override
    public void skip(long l) {
        while (l > 0L) {
            Segment segment = this.head;
            if (segment != null) {
                Buffer buffer = this;
                int n = (int)Math.min(l, (long)(segment.limit - segment.pos));
                long l2 = n;
                buffer.setSize$okio(buffer.size() - l2);
                l2 = l - l2;
                segment.pos = n = segment.pos + n;
                if (n == segment.limit) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
                l = l2;
                continue;
            }
            throw new EOFException();
        }
    }

    @Override
    public Buffer write(ByteString byteString) {
        ByteString byteString2 = byteString;
        Intrinsics.checkNotNullParameter(byteString2, "byteString");
        int n = byteString2.size();
        byteString2.write$okio(this, 0, n);
        return this;
    }

    @Override
    public Buffer writeUtf8(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "string");
        return this.writeUtf8(string2, 0, string2.length());
    }

    public Buffer writeUtf8(String string, int n, int n2) {
        Object object;
        Intrinsics.checkNotNullParameter(string, "string");
        if (n >= 0) {
            if (n2 >= n) {
                if (n2 <= string.length()) {
                    while (n < n2) {
                        int n3 = string.charAt(n);
                        if (n3 < 128) {
                            Segment segment = ((Buffer)object).writableSegment$okio(1);
                            byte[] byArray = segment.data;
                            int n4 = n3;
                            n3 = segment.limit - n;
                            int n5 = Math.min(n2, 8192 - n3);
                            int n6 = n3 + n++;
                            segment.data[n6] = (byte)n4;
                            while (n < n5) {
                                char c = string.charAt(n);
                                n6 = c;
                                if (c >= '\u0080') break;
                                int n7 = n6;
                                n6 = n + 1;
                                n = n3 + n;
                                byArray[n] = (byte)n7;
                                n = n6;
                            }
                            Object object2 = object;
                            n3 = n + n3;
                            int n8 = segment.limit;
                            segment.limit = n8 + (n3 -= n8);
                            ((Buffer)object2).setSize$okio(((Buffer)object2).size() + (long)n3);
                            continue;
                        }
                        if (n3 < 2048) {
                            Object object3 = object;
                            Segment segment = ((Buffer)object3).writableSegment$okio(2);
                            byte[] byArray = segment.data;
                            int n9 = segment.limit;
                            int n10 = n3;
                            byArray[n9] = (byte)(n3 >> 6 | 0xC0);
                            n3 = n9 + 1;
                            byArray[n3] = (byte)(n10 & 0x3F | 0x80);
                            segment.limit = n9 + 2;
                            ((Buffer)object3).setSize$okio(((Buffer)object3).size() + 2L);
                            ++n;
                            continue;
                        }
                        if (n3 >= 55296 && n3 <= 57343) {
                            int n11 = n + 1;
                            int n12 = n11 < n2 ? string.charAt(n11) : 0;
                            if (n3 <= 56319 && 56320 <= n12 && n12 < 57344) {
                                Object object4 = object;
                                n3 = ((n3 & 0x3FF) << 10 | n12 & 0x3FF) + 65536;
                                Segment segment = ((Buffer)object4).writableSegment$okio(4);
                                byte[] byArray = segment.data;
                                n12 = segment.limit;
                                int n13 = n3;
                                int n14 = n3;
                                int n15 = n3;
                                byArray[n12] = (byte)(n3 >> 18 | 0xF0);
                                n3 = n12 + 1;
                                byArray[n3] = (byte)(n15 >> 12 & 0x3F | 0x80);
                                n3 = n12 + 2;
                                byArray[n3] = (byte)(n14 >> 6 & 0x3F | 0x80);
                                n3 = n12 + 3;
                                byArray[n3] = (byte)(n13 & 0x3F | 0x80);
                                segment.limit = n12 + 4;
                                ((Buffer)object4).setSize$okio(((Buffer)object4).size() + 4L);
                                n += 2;
                                continue;
                            }
                            ((Buffer)object).writeByte(63);
                            n = n11;
                            continue;
                        }
                        Object object5 = object;
                        Segment segment = ((Buffer)object5).writableSegment$okio(3);
                        byte[] byArray = segment.data;
                        int n16 = segment.limit;
                        int n17 = n3;
                        int n18 = n3;
                        byArray[n16] = (byte)(n3 >> 12 | 0xE0);
                        n3 = n16 + 1;
                        byArray[n3] = (byte)(n18 >> 6 & 0x3F | 0x80);
                        n3 = n16 + 2;
                        byArray[n3] = (byte)(n17 & 0x3F | 0x80);
                        segment.limit = n16 + 3;
                        ((Buffer)object5).setSize$okio(((Buffer)object5).size() + 3L);
                        ++n;
                    }
                    return object;
                }
                object = "endIndex > string.length: " + n2 + " > " + string.length();
                throw new IllegalArgumentException(object.toString());
            }
            object = "endIndex < beginIndex: " + n2 + " < " + n;
            throw new IllegalArgumentException(object.toString());
        }
        object = "beginIndex < 0: " + n;
        throw new IllegalArgumentException(object.toString());
    }

    public Buffer writeUtf8CodePoint(int n) {
        block7: {
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                if (n >= 128) break block2;
                                this.writeByte(n);
                                break block3;
                            }
                            if (n >= 2048) break block4;
                            Buffer buffer = this;
                            Segment segment = buffer.writableSegment$okio(2);
                            byte[] byArray = segment.data;
                            int n2 = segment.limit;
                            int n3 = n;
                            byArray[n2] = (byte)(n >> 6 | 0xC0);
                            n = n2 + 1;
                            byArray[n] = (byte)(n3 & 0x3F | 0x80);
                            segment.limit = n2 + 2;
                            buffer.setSize$okio(buffer.size() + 2L);
                            break block3;
                        }
                        if (!(55296 <= n && n < 57344)) break block5;
                        this.writeByte(63);
                        break block3;
                    }
                    if (n >= 65536) break block6;
                    Buffer buffer = this;
                    Segment segment = buffer.writableSegment$okio(3);
                    byte[] byArray = segment.data;
                    int n4 = segment.limit;
                    int n5 = n;
                    int n6 = n;
                    byArray[n4] = (byte)(n >> 12 | 0xE0);
                    n = n4 + 1;
                    byArray[n] = (byte)(n6 >> 6 & 0x3F | 0x80);
                    n = n4 + 2;
                    byArray[n] = (byte)(n5 & 0x3F | 0x80);
                    segment.limit = n4 + 3;
                    buffer.setSize$okio(buffer.size() + 3L);
                    break block3;
                }
                if (n > 0x10FFFF) break block7;
                Buffer buffer = this;
                Segment segment = buffer.writableSegment$okio(4);
                byte[] byArray = segment.data;
                int n7 = segment.limit;
                int n8 = n;
                int n9 = n;
                int n10 = n;
                byArray[n7] = (byte)(n >> 18 | 0xF0);
                n = n7 + 1;
                byArray[n] = (byte)(n10 >> 12 & 0x3F | 0x80);
                n = n7 + 2;
                byArray[n] = (byte)(n9 >> 6 & 0x3F | 0x80);
                n = n7 + 3;
                byArray[n] = (byte)(n8 & 0x3F | 0x80);
                segment.limit = n7 + 4;
                buffer.setSize$okio(buffer.size() + 4L);
            }
            return this;
        }
        throw new IllegalArgumentException("Unexpected code point: 0x" + _UtilKt.toHexString(n));
    }

    public Buffer writeString(String string, int n, int n2, Charset charset) {
        Object object;
        Intrinsics.checkNotNullParameter(string, "string");
        Intrinsics.checkNotNullParameter(charset, "charset");
        if (n >= 0) {
            if (n2 >= n) {
                if (n2 <= string.length()) {
                    if (Intrinsics.areEqual(charset, Charsets.UTF_8)) {
                        return ((Buffer)object).writeUtf8(string, n, n2);
                    }
                    String string2 = string.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
                    return ((Buffer)object).write(byArray, 0, byArray.length);
                }
                object = "endIndex > string.length: " + n2 + " > " + string.length();
                throw new IllegalArgumentException(object.toString());
            }
            object = "endIndex < beginIndex: " + n2 + " < " + n;
            throw new IllegalArgumentException(object.toString());
        }
        object = "beginIndex < 0: " + n;
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public Buffer write(byte[] byArray) {
        byte[] byArray2 = byArray;
        Intrinsics.checkNotNullParameter(byArray2, "source");
        return this.write(byArray, 0, byArray2.length);
    }

    @Override
    public Buffer write(byte[] byArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(byArray, "source");
        long l = n;
        long l2 = n2;
        _UtilKt.checkOffsetAndCount(byArray.length, l, l2);
        n2 = n + n2;
        while (n < n2) {
            Segment segment;
            Segment segment2 = segment = this.writableSegment$okio(1);
            int n3 = Math.min(n2 - n, 8192 - segment.limit);
            byte[] byArray2 = segment2.data;
            int n4 = segment2.limit;
            int n5 = n + n3;
            ArraysKt.copyInto(byArray, byArray2, n4, n, n5);
            segment.limit += n3;
            n = n5;
        }
        Buffer buffer = this;
        buffer.setSize$okio(buffer.size() + l2);
        return buffer;
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        int n;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "source");
        int n2 = n = byteBuffer2.remaining();
        while (n2 > 0) {
            Segment segment = this.writableSegment$okio(1);
            Object object = segment;
            int n3 = n2;
            Segment segment2 = object;
            n2 = Math.min(n2, 8192 - ((Segment)object).limit);
            object = segment2.data;
            byteBuffer.get((byte[])object, segment2.limit, n2);
            int n4 = n3 - n2;
            segment.limit += n2;
            n2 = n4;
        }
        this.size += (long)n;
        return n;
    }

    public long writeAll(Source source2) {
        long l;
        Intrinsics.checkNotNullParameter(source2, "source");
        long l2 = 0L;
        while ((l = source2.read(this, 8192L)) != -1L) {
            l2 += l;
        }
        return l2;
    }

    @Override
    public Buffer writeByte(int n) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment$okio(1);
        int n2 = segment.limit;
        segment.limit = n2 + 1;
        segment.data[n2] = (byte)n;
        buffer.setSize$okio(buffer.size() + 1L);
        return buffer;
    }

    @Override
    public Buffer writeShort(int n) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment$okio(2);
        int n2 = n;
        int n3 = segment.limit;
        n = n3 + 1;
        segment.data[n3] = (byte)(n2 >>> 8 & 0xFF);
        n3 = n + 1;
        segment.data[n] = (byte)(n & 0xFF);
        segment.limit = n3;
        buffer.setSize$okio(buffer.size() + 2L);
        return buffer;
    }

    @Override
    public Buffer writeInt(int n) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment$okio(4);
        byte[] byArray = segment.data;
        int n2 = n;
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = segment.limit;
        n = n6 + 1;
        byArray[n6] = (byte)(n5 >>> 24 & 0xFF);
        n6 = n + 1;
        byArray[n] = (byte)(n4 >>> 16 & 0xFF);
        n = n6 + 1;
        byArray[n6] = (byte)(n3 >>> 8 & 0xFF);
        n6 = n + 1;
        segment.data[n] = (byte)(n2 & 0xFF);
        segment.limit = n6;
        buffer.setSize$okio(buffer.size() + 4L);
        return buffer;
    }

    @Override
    public Buffer writeHexadecimalUnsignedLong(long l) {
        if (l == 0L) {
            Buffer buffer = buffer.writeByte(48);
        } else {
            long l2 = l;
            long l3 = l2 | l2 >>> 1;
            long l4 = l3 | l3 >>> 2;
            long l5 = l4 | l4 >>> 4;
            long l6 = l5 | l5 >>> 8;
            long l7 = l6 | l6 >>> 16;
            long l8 = l7 | l7 >>> 32;
            long l9 = l8 - (l8 >>> 1 & 0x5555555555555555L);
            l9 = (l9 >>> 2 & 0x3333333333333333L) + (l9 & 0x3333333333333333L);
            long l10 = (l9 >>> 4) + l9 & 0xF0F0F0F0F0F0F0FL;
            long l11 = l10 + (l10 >>> 8);
            l9 = l11 + (l11 >>> 16);
            int n = (int)(((l9 & 0x3FL) + (l9 >>> 32 & 0x3FL) + (long)3) / (long)4);
            Segment segment = buffer.writableSegment$okio(n);
            byte[] byArray = segment.data;
            int n2 = segment.limit;
            for (int i = n2 + n - 1; i >= n2; --i) {
                byArray[i] = _BufferKt.getHEX_DIGIT_BYTES()[(int)(l & 0xFL)];
                l >>>= 4;
            }
            Buffer buffer = buffer;
            segment.limit += n;
            buffer.setSize$okio(buffer.size() + (long)n);
        }
        return buffer;
    }

    public final Segment writableSegment$okio(int n) {
        if (n >= 1 && n <= 8192) {
            Object object;
            Segment segment = ((Buffer)object2).head;
            if (segment == null) {
                object = SegmentPool.take();
                ((Buffer)object2).head = object;
                SegmentPool.take().prev = object;
                SegmentPool.take().next = object;
            } else {
                Segment segment2 = segment;
                Intrinsics.checkNotNull(segment2);
                Object object2 = segment2.prev;
                Intrinsics.checkNotNull(object2);
                object = ((Segment)object2).limit + n <= 8192 && ((Segment)object2).owner ? object2 : (object2 = ((Segment)object2).push(SegmentPool.take()));
            }
            return object;
        }
        throw new IllegalArgumentException("unexpected capacity".toString());
    }

    @Override
    public void write(Buffer buffer, long l) {
        Buffer buffer2 = buffer;
        Intrinsics.checkNotNullParameter(buffer2, "source");
        if (buffer2 != segment5) {
            _UtilKt.checkOffsetAndCount(buffer.size(), 0L, l);
            while (l > 0L) {
                long l2;
                Segment segment;
                Segment segment2 = buffer.head;
                Intrinsics.checkNotNull(segment2);
                int n = segment2.limit;
                Segment segment3 = buffer.head;
                Intrinsics.checkNotNull(segment3);
                if (l < (long)(n - segment3.pos)) {
                    long l3;
                    segment = ((Buffer)((Object)segment5)).head;
                    if (segment != null) {
                        Segment segment4 = segment;
                        Intrinsics.checkNotNull(segment4);
                        segment = segment4.prev;
                    } else {
                        segment = null;
                    }
                    if (segment != null && segment.owner && (l2 = l + (long)segment.limit) - (l3 = (long)(segment.shared ? 0 : segment.pos)) <= 8192L) {
                        Buffer buffer3 = segment5;
                        Buffer buffer4 = buffer;
                        Segment segment5 = buffer4.head;
                        Intrinsics.checkNotNull(segment5);
                        segment5.writeTo(segment, (int)l);
                        buffer4.setSize$okio(buffer4.size() - l);
                        buffer3.setSize$okio(buffer3.size() + l);
                        break;
                    }
                    segment = buffer.head;
                    Intrinsics.checkNotNull(segment);
                    buffer.head = segment.split((int)l);
                }
                segment = buffer.head;
                Intrinsics.checkNotNull(segment);
                l2 = segment.limit - segment.pos;
                buffer.head = segment.pop();
                Segment segment6 = ((Buffer)((Object)segment5)).head;
                if (segment6 == null) {
                    Segment segment7 = ((Buffer)((Object)segment5)).head = segment;
                    segment7.prev = segment;
                    segment7.next = segment;
                } else {
                    Segment segment8 = segment6;
                    Intrinsics.checkNotNull(segment8);
                    Segment segment9 = segment8.prev;
                    Intrinsics.checkNotNull(segment9);
                    segment9.push(segment).compact();
                }
                Buffer buffer5 = segment5;
                Buffer buffer6 = buffer;
                buffer6.setSize$okio(buffer6.size() - l2);
                buffer5.setSize$okio(buffer5.size() + l2);
                l -= l2;
            }
            return;
        }
        throw new IllegalArgumentException("source == this".toString());
    }

    @Override
    public long read(Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "sink");
        if (l >= 0L) {
            long l2;
            if (((Buffer)((Object)string)).size() == 0L) {
                l2 = -1L;
            } else {
                if (l > ((Buffer)((Object)string)).size()) {
                    l = ((Buffer)((Object)string)).size();
                }
                buffer.write((Buffer)((Object)string), l);
                l2 = l;
            }
            return l2;
        }
        String string = "byteCount < 0: " + l;
        throw new IllegalArgumentException(string.toString());
    }

    /*
     * Unable to fully structure code
     */
    public long indexOf(byte var1_1, long var2_2, long var4_4) {
        block11: {
            block10: {
                block12: {
                    if (!(0L <= var2_2 && var2_2 <= var4_4)) break block11;
                    if (var4_4 > this.size()) {
                        var4_4 = this.size();
                    }
                    if (var2_2 == var4_4) lbl-1000:
                    // 4 sources

                    {
                        while (true) {
                            v0 = -1L;
                            break block10;
                            break;
                        }
                    }
                    var6_5 = this.head;
                    if (var6_5 == null) ** GOTO lbl-1000
                    if (this.size() - var2_2 >= var2_2) break block12;
                    for (var7_6 = this.size(); var7_6 > var2_2; var7_6 -= (long)(var6_5.limit - var6_5.pos)) {
                        var6_5 = var6_5.prev;
                        Intrinsics.checkNotNull(var6_5);
                    }
                    while (true) {
                        if (var7_6 >= var4_4) ** GOTO lbl-1000
                        v1 = var6_5;
                        this = v1.data;
                        var9_7 = (int)Math.min((long)v1.limit, (long)var6_5.pos + var4_4 - var7_6);
                        for (var2_3 = (int)((long)(v499161).pos + var2_2 - var7_6); var2_3 < var9_7; ++var2_3) {
                            if (this[var2_3] != var1_1) {
                                continue;
                            }
                            ** GOTO lbl43
                        }
                        var6_5 = var6_5.next;
                        Intrinsics.checkNotNull(var6_5);
                        var2_2 = var7_6 += (long)(var6_5.limit - var6_5.pos);
                    }
                }
                var7_6 = 0L;
                while ((var9_8 = var7_6 + (long)(var6_5.limit - var6_5.pos)) <= var2_2) {
                    var6_5 = var6_5.next;
                    Intrinsics.checkNotNull(var6_5);
                    var7_6 = var9_8;
                }
                block5: while (true) {
                    if (var7_6 < var4_4) ** break;
                    ** continue;
                    v2 = var6_5;
                    this = v2.data;
                    var9_9 = (int)Math.min((long)v2.limit, (long)var6_5.pos + var4_4 - var7_6);
                    for (var2_3 = (int)((long)(v499236).pos + var2_2 - var7_6); var2_3 < var9_9; ++var2_3) {
                        if (this[var2_3] != var1_1) continue;
lbl43:
                        // 2 sources

                        v0 = (long)(var2_3 - var6_5.pos) + var7_6;
                        break block5;
                    }
                    var6_5 = var6_5.next;
                    Intrinsics.checkNotNull(var6_5);
                    var2_2 = var7_6 += (long)(var6_5.limit - var6_5.pos);
                }
            }
            return v0;
        }
        this = "size=" + this.size() + " fromIndex=" + var2_2 + " toIndex=" + var4_4;
        throw new IllegalArgumentException(this.toString());
    }

    public long indexOfElement(ByteString byteString) {
        ByteString byteString2 = byteString;
        Intrinsics.checkNotNullParameter(byteString2, "targetBytes");
        return this.indexOfElement(byteString2, 0L);
    }

    /*
     * Enabled aggressive block sorting
     */
    public long indexOfElement(ByteString object, long l) {
        long l2;
        int n;
        long l3;
        Segment segment;
        block21: {
            block26: {
                int n2;
                block20: {
                    block25: {
                        block24: {
                            block23: {
                                long l4;
                                block22: {
                                    Intrinsics.checkNotNullParameter(object, "targetBytes");
                                    if (!(l >= 0L)) {
                                        String string = "fromIndex < 0: " + l;
                                        throw new IllegalArgumentException(string.toString());
                                    }
                                    segment = ((Buffer)((Object)string)).head;
                                    if (segment == null) return -1L;
                                    if (((Buffer)((Object)string)).size() - l >= l) break block22;
                                    for (l3 = ((Buffer)((Object)string)).size(); l3 > l; l3 -= (long)(segment.limit - segment.pos)) {
                                        segment = segment.prev;
                                        Intrinsics.checkNotNull(segment);
                                    }
                                    if (((ByteString)object).size() == 2) break block23;
                                    break block24;
                                }
                                l3 = 0L;
                                while ((l4 = l3 + (long)(segment.limit - segment.pos)) <= l) {
                                    segment = segment.next;
                                    Intrinsics.checkNotNull(segment);
                                    l3 = l4;
                                }
                                if (((ByteString)object).size() == 2) break block25;
                                break block26;
                            }
                            Object object2 = object;
                            byte by = ((ByteString)object2).getByte(0);
                            byte by2 = ((ByteString)object2).getByte(1);
                            while (l3 < ((Buffer)((Object)string)).size()) {
                                Segment segment2 = segment;
                                byte[] byArray = segment2.data;
                                int n3 = segment2.limit;
                                for (n2 = (int)((long)(v502638).pos + l - l3); n2 < n3; ++n2) {
                                    byte by3 = byArray[n2];
                                    if (by3 != by && by3 != by2) {
                                        continue;
                                    }
                                    break block20;
                                }
                                segment = segment.next;
                                Intrinsics.checkNotNull(segment);
                                l = l3 += (long)(segment.limit - segment.pos);
                            }
                            return -1L;
                        }
                        object = ((ByteString)object).internalArray$okio();
                        block4: while (true) {
                            if (l3 >= ((Buffer)((Object)string)).size()) return -1L;
                            Segment segment3 = segment;
                            byte[] byArray = segment3.data;
                            n = (int)((long)segment3.pos + l - l3);
                            int n4 = segment3.limit;
                            while (true) {
                                int n5;
                                byte by;
                                if (n < n4) {
                                    by = byArray[n];
                                    n5 = ((Object)object).length;
                                } else {
                                    segment = segment.next;
                                    Intrinsics.checkNotNull(segment);
                                    l = l3 += (long)(segment.limit - segment.pos);
                                    continue block4;
                                }
                                for (int i = 0; i < n5; ++i) {
                                    if (by != object[i]) {
                                        continue;
                                    }
                                    break block21;
                                }
                                ++n;
                            }
                            break;
                        }
                    }
                    Object object3 = object;
                    byte by = ((ByteString)object3).getByte(0);
                    byte by4 = ((ByteString)object3).getByte(1);
                    while (l3 < ((Buffer)((Object)string)).size()) {
                        Segment segment4 = segment;
                        byte[] byArray = segment4.data;
                        int n6 = segment4.limit;
                        for (n2 = (int)((long)(v502777).pos + l - l3); n2 < n6; ++n2) {
                            byte by5 = byArray[n2];
                            if (by5 != by && by5 != by4) {
                                continue;
                            }
                            break block20;
                        }
                        segment = segment.next;
                        Intrinsics.checkNotNull(segment);
                        l = l3 += (long)(segment.limit - segment.pos);
                    }
                    return -1L;
                }
                l2 = (long)(n2 - segment.pos) + l3;
                return l2;
            }
            object = ((ByteString)object).internalArray$okio();
            block9: while (true) {
                if (l3 >= ((Buffer)((Object)string)).size()) return -1L;
                Segment segment5 = segment;
                byte[] byArray = segment5.data;
                n = (int)((long)segment5.pos + l - l3);
                int n7 = segment5.limit;
                while (true) {
                    int n8;
                    byte by;
                    if (n < n7) {
                        by = byArray[n];
                        n8 = ((Object)object).length;
                    } else {
                        segment = segment.next;
                        Intrinsics.checkNotNull(segment);
                        l = l3 += (long)(segment.limit - segment.pos);
                        continue block9;
                    }
                    for (int i = 0; i < n8; ++i) {
                        if (by == object[i]) break block9;
                    }
                    ++n;
                }
                break;
            }
        }
        l2 = (long)(n - segment.pos) + l3;
        return l2;
    }

    public boolean rangeEquals(long l, ByteString byteString) {
        ByteString byteString2 = byteString;
        Intrinsics.checkNotNullParameter(byteString2, "bytes");
        int n = byteString2.size();
        return this.rangeEquals(l, byteString, 0, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean rangeEquals(long l, ByteString byteString, int n, int n2) {
        Intrinsics.checkNotNullParameter(byteString, "bytes");
        if (l < 0L) return false;
        if (n < 0) return false;
        if (n2 < 0) return false;
        if (this.size() - l < (long)n2) return false;
        if (byteString.size() - n < n2) return false;
        int n3 = 0;
        while (n3 < n2) {
            if (this.getByte(l + (long)n3) != byteString.getByte(n + n3)) return false;
            ++n3;
        }
        return true;
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public Timeout timeout() {
        return Timeout.NONE;
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object var1_1) {
        block8: {
            if (this == var1_1) lbl-1000:
            // 3 sources

            {
                while (true) {
                    v0 = true;
                    break block8;
                    break;
                }
            }
            if (!(var1_1 instanceof Buffer)) lbl-1000:
            // 3 sources

            {
                while (true) {
                    v0 = false;
                    break block8;
                    break;
                }
            }
            var1_1 = (Buffer)var1_1;
            if (this.size() != var1_1.size()) ** GOTO lbl-1000
            if (this.size() == 0L) ** GOTO lbl-1000
            v1 = var1_1;
            var1_1 = this.head;
            Intrinsics.checkNotNull(var1_1);
            var2_2 = v1.head;
            Intrinsics.checkNotNull(var2_2);
            var3_3 = var1_1.pos;
            var4_4 = var2_2.pos;
            var5_5 = 0L;
            while (true) {
                if (var5_5 < this.size()) ** break;
                ** continue;
                var7_6 = Math.min(var1_1.limit - var3_3, var2_2.limit - var4_4);
                for (var9_7 = 0L; var9_7 < var7_6; ++var9_7) {
                    if (var1_1.data[var3_3++] == var2_2.data[var4_4++]) continue;
                    ** continue;
                }
                if (var3_3 == var1_1.limit) {
                    var1_1 = var1_1.next;
                    Intrinsics.checkNotNull(var1_1);
                    var3_3 = var1_1.pos;
                }
                if (var4_4 == var2_2.limit) {
                    var2_2 = var2_2.next;
                    Intrinsics.checkNotNull(var2_2);
                    var4_4 = var2_2.pos;
                }
                var5_5 += var7_6;
            }
        }
        return v0;
    }

    public int hashCode() {
        int n;
        Segment segment = this.head;
        if (segment == null) {
            n = 0;
        } else {
            int n2 = 1;
            do {
                int n3 = segment.limit;
                for (int i = (v504019).pos; i < n3; ++i) {
                    n2 = n2 * 31 + segment.data[i];
                }
                segment = segment.next;
                Intrinsics.checkNotNull(segment);
            } while (segment != this.head);
            n = n2;
        }
        return n;
    }

    public String toString() {
        return this.snapshot().toString();
    }

    public final Buffer copy() {
        Buffer buffer;
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        if (this.size() != 0L) {
            Segment segment;
            Segment segment2 = this.head;
            Intrinsics.checkNotNull(segment2);
            buffer2.head = segment = segment2.sharedCopy();
            segment2.sharedCopy().prev = segment;
            segment2.sharedCopy().next = segment;
            Segment segment3 = segment2.next;
            while (segment3 != segment2) {
                Segment segment4 = segment.prev;
                Segment segment5 = segment3;
                Intrinsics.checkNotNull(segment4);
                Intrinsics.checkNotNull(segment5);
                segment4.push(segment5.sharedCopy());
                segment3 = segment3.next;
            }
            buffer2.setSize$okio(this.size());
        }
        return buffer2;
    }

    public Buffer clone() {
        return this.copy();
    }

    public final ByteString snapshot() {
        if (((Buffer)((Object)string)).size() <= Integer.MAX_VALUE) {
            Buffer buffer = string;
            return buffer.snapshot((int)buffer.size());
        }
        String string = "size > Int.MAX_VALUE: " + ((Buffer)((Object)string)).size();
        throw new IllegalStateException(string.toString());
    }

    public final ByteString snapshot(int n) {
        Object object;
        if (n == 0) {
            object = ByteString.EMPTY;
        } else {
            SegmentedByteString segmentedByteString;
            int n2;
            Buffer buffer = object;
            long l = n;
            _UtilKt.checkOffsetAndCount(buffer.size(), 0L, l);
            int n3 = 0;
            int n4 = 0;
            Segment segment = buffer.head;
            while (n3 < n) {
                Segment segment2 = segment;
                Intrinsics.checkNotNull(segment2);
                n2 = segment2.limit;
                int n5 = segment.pos;
                if (n2 != n5) {
                    n3 += n2 - n5;
                    ++n4;
                    segment = segment.next;
                    continue;
                }
                throw new AssertionError((Object)"s.limit == s.pos");
            }
            Object object2 = object;
            int n6 = n4;
            object = new byte[n6][];
            int[] nArray = new int[n6 * 2];
            int n7 = 0;
            n2 = 0;
            Segment segment3 = ((Buffer)object2).head;
            while (n7 < n) {
                Segment segment4 = segment3;
                Intrinsics.checkNotNull(segment4);
                object[n2] = segment4.data;
                nArray[n2] = Math.min(n7 += segment3.limit - segment3.pos, n);
                int n8 = n2 + n4;
                nArray[n8] = segment3.pos;
                segment3.shared = true;
                ++n2;
                segment3 = segment3.next;
            }
            SegmentedByteString segmentedByteString2 = segmentedByteString;
            segmentedByteString = new SegmentedByteString((byte[][])object, nArray);
            object = segmentedByteString2;
        }
        return object;
    }
}

